/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.zone.order.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.zone.order.api.IcascQueryOrderInfoForPayListAbilityService;
import com.tydic.dyc.zone.order.bo.IcascOrderInfoBO;
import com.tydic.dyc.zone.order.bo.IcascQueryOrderInfoForPayReqBO;
import com.tydic.dyc.zone.order.bo.IcascQueryOrderInfoForPayRspBO;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcascQueryOrderInfoForPayListAbilityServiceImpl
implements IcascQueryOrderInfoForPayListAbilityService {
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;

    public IcascQueryOrderInfoForPayRspBO queryOrderInfoForPayList(IcascQueryOrderInfoForPayReqBO reqBO) {
        PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO = new PebExtSalesSingleDetailsListQueryReqBO();
        this.buildReqestBO(reqBO, pebExtSalesSingleDetailsListQueryReqBO);
        PebExtSalesSingleDetailsListQueryRspBO centerRspBO = this.pebExtSalesSingleDetailsListQueryAbilityService.getPebExtSalesSingleDetailsListQuery(pebExtSalesSingleDetailsListQueryReqBO);
        if (!"0000".equals(centerRspBO.getRespCode())) {
            throw new ZTBusinessException(centerRspBO.getRespDesc());
        }
        IcascQueryOrderInfoForPayRspBO rspBO = new IcascQueryOrderInfoForPayRspBO();
        ArrayList<IcascOrderInfoBO> orderInfoBOS = new ArrayList<IcascOrderInfoBO>();
        this.buildRspInfo(centerRspBO.getRows(), orderInfoBOS);
        rspBO.setPageNo(centerRspBO.getPageNo());
        rspBO.setTotal(centerRspBO.getTotal());
        rspBO.setRecordsTotal(centerRspBO.getRecordsTotal());
        rspBO.setCode(centerRspBO.getRespCode());
        rspBO.setMessage(centerRspBO.getRespDesc());
        rspBO.setRows(orderInfoBOS);
        return null;
    }

    private void buildRspInfo(List<PebExtUpperOrderAbilityBO> rows, List<IcascOrderInfoBO> orderInfoBOS) {
        if (CollectionUtils.isNotEmpty(rows)) {
            for (PebExtUpperOrderAbilityBO row : rows) {
                IcascOrderInfoBO icascOrderInfoBO = new IcascOrderInfoBO();
                icascOrderInfoBO.setSaleGrandpaOrderCode(row.getParOrdNo());
                icascOrderInfoBO.setSaleOrderCode(row.getSaleVoucherNo());
                icascOrderInfoBO.setPurchaseNo(Long.valueOf(Long.parseLong(((PebExtChildOrderAbilityBO)row.getChildOrderList().get(0)).getPurAccount())));
                icascOrderInfoBO.setPurName(((PebExtChildOrderAbilityBO)row.getChildOrderList().get(0)).getPurName());
                icascOrderInfoBO.setOrderCreateOperId(row.getCreateOperId());
                icascOrderInfoBO.setCreateOperName(row.getCreateOperName());
                icascOrderInfoBO.setAccountId(Long.valueOf(Long.parseLong(((PebExtChildOrderAbilityBO)row.getChildOrderList().get(0)).getPurNo())));
                icascOrderInfoBO.setAccountName(((PebExtChildOrderAbilityBO)row.getChildOrderList().get(0)).getPurAccountName());
                icascOrderInfoBO.setCreateTime(DateUtils.strToDate((String)row.getCreateTime()));
                icascOrderInfoBO.setSupId(Long.valueOf(Long.parseLong(row.getSupNo())));
                icascOrderInfoBO.setSupName(row.getSupName());
                icascOrderInfoBO.setOrderAmt(new BigDecimal(((PebExtChildOrderAbilityBO)row.getChildOrderList().get(0)).getSaleFeeMoney()));
                icascOrderInfoBO.setOrderStatusStr(((PebExtChildOrderAbilityBO)row.getChildOrderList().get(0)).getSaleStateStr());
            }
        }
    }

    private void buildReqestBO(IcascQueryOrderInfoForPayReqBO reqBO, PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO) {
        pebExtSalesSingleDetailsListQueryReqBO.setTabId(Integer.valueOf(30001));
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSource())) {
            pebExtSalesSingleDetailsListQueryReqBO.setAgreementMode(Integer.valueOf(Integer.parseInt(reqBO.getSource())));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleGrandpaOrderCode())) {
            pebExtSalesSingleDetailsListQueryReqBO.setParOrdNo(reqBO.getSaleGrandpaOrderCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderCode())) {
            pebExtSalesSingleDetailsListQueryReqBO.setSaleVoucherNo(reqBO.getSaleOrderCode());
        }
        if (Objects.nonNull(reqBO.getPurchaseNo())) {
            pebExtSalesSingleDetailsListQueryReqBO.setPurNo(String.valueOf(reqBO.getPurchaseNo()));
        }
        if (Objects.nonNull(reqBO.getPurchaseProjectId())) {
            pebExtSalesSingleDetailsListQueryReqBO.setPurAccount(String.valueOf(reqBO.getPurchaseProjectId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getPurchaseProjectIdList())) {
            List purAccountIdList = reqBO.getPurchaseProjectIdList().stream().map(String::valueOf).collect(Collectors.toList());
            pebExtSalesSingleDetailsListQueryReqBO.setPurAccountList(purAccountIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderStatus())) {
            pebExtSalesSingleDetailsListQueryReqBO.setSaleState(Integer.valueOf(Integer.parseInt(reqBO.getOrderStatus())));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (Objects.nonNull(reqBO.getOrderDateStart())) {
            pebExtSalesSingleDetailsListQueryReqBO.setCreateTimeEff(sdf.format(reqBO.getOrderDateStart()));
        }
        if (Objects.nonNull(reqBO.getOrderDateEnd())) {
            pebExtSalesSingleDetailsListQueryReqBO.setCreateTimeExp(sdf.format(reqBO.getOrderDateEnd()));
        }
        if (Objects.nonNull(reqBO.getSupplierNo())) {
            pebExtSalesSingleDetailsListQueryReqBO.setSupNo(String.valueOf(reqBO.getSupplierNo()));
        }
        if (Objects.nonNull(reqBO.getPurchaserName())) {
            pebExtSalesSingleDetailsListQueryReqBO.setCreateOperName(reqBO.getPurchaserName());
        }
        pebExtSalesSingleDetailsListQueryReqBO.setPageNo(reqBO.getPageNo());
        pebExtSalesSingleDetailsListQueryReqBO.setPageSize(reqBO.getPageSize());
    }
}

