/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UmcStationWebBO;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.common.ability.api.DycUccMemWaitDoneDetailListQryAbilityService;
import com.tydic.commodity.common.ability.bo.DycUccMemWaitDoneDetailListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.DycUccMemWaitDoneDetailListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.DycUccWaitDoneDetailBO;
import com.tydic.commodity.common.ability.bo.UccMemWatiDoneRuleBO;
import com.tydic.commodity.common.busi.api.UccMsearchEsService;
import com.tydic.commodity.common.busi.bo.UccMsearchEsReqBO;
import com.tydic.commodity.common.busi.bo.UccMsearchEsRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.DycUccMemWaitDoneDetailListQryAbilityService"})
public class DycUccMemWaitDoneDetailListQryAbilityServiceImpl
implements DycUccMemWaitDoneDetailListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycUccMemWaitDoneDetailListQryAbilityServiceImpl.class);
    private static final Map<String, UccMemWatiDoneRuleBO> menuInfoMap = new HashMap<String, UccMemWatiDoneRuleBO>();
    @Autowired
    private UccMsearchEsService uccMsearchEsService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"qryWaitDoneDetailList"})
    public DycUccMemWaitDoneDetailListQryAbilityRspBO qryWaitDoneDetailList(@RequestBody DycUccMemWaitDoneDetailListQryAbilityReqBO reqBO) {
        DycUccMemWaitDoneDetailListQryAbilityRspBO rspBO = new DycUccMemWaitDoneDetailListQryAbilityRspBO();
        if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getMenuCode())) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), RspConstantEnums.REQUIRED_NON_EMPTY.message());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Date date = this.queryDBDateBusiService.getDBDate();
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.setTimeZone(tz);
        Long today = calendar.getTimeInMillis();
        ArrayList<String> query = new ArrayList<String>();
        UccMsearchEsReqBO uccMsearchEsNormalReqBO = new UccMsearchEsReqBO();
        uccMsearchEsNormalReqBO.setTotal(true);
        uccMsearchEsNormalReqBO.setFrom(1);
        uccMsearchEsNormalReqBO.setSize(1);
        uccMsearchEsNormalReqBO.setQuery(query);
        List stationIds = reqBO.getUmcStationsListWebExt().stream().map(UmcStationWebBO::getStationId).collect(Collectors.toList());
        for (String each : reqBO.getMenuCode()) {
            if (menuInfoMap.containsKey(each)) {
                BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)menuInfoMap.get(each).getSkuSource()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"spu_approval_status", (Collection)menuInfoMap.get(each).getApprovalStatus()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)menuInfoMap.get(each).getSkuStaus()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", stationIds));
                JSONObject queryJson = new JSONObject();
                JSONObject aggs = new JSONObject();
                JSONObject cardinality = new JSONObject();
                JSONObject field = new JSONObject();
                if (menuInfoMap.get(each).getType() == 0) {
                    field.put("field", (Object)"commodity_id");
                } else {
                    field.put("field", (Object)"sku_id");
                }
                cardinality.put("cardinality", (Object)field);
                aggs.put("cardinality_count", (Object)cardinality);
                queryJson.put("aggs", (Object)aggs);
                queryJson.put("query", (Object)JSONObject.parseObject((String)extBoolQueryBuilder.toString().replace("\\n", "").replace(" ", "")));
                queryJson.put("size", (Object)1);
                queryJson.put("from", (Object)1);
                query.add(queryJson.toString());
                continue;
            }
            throw new BusinessException(RspConstantEnums.MEM_WAIT_DONE_EXIST.code(), RspConstantEnums.MEM_WAIT_DONE_EXIST.message());
        }
        ArrayList<String> queryDay = new ArrayList<String>();
        UccMsearchEsReqBO uccMsearchEsDayReqBO = new UccMsearchEsReqBO();
        uccMsearchEsDayReqBO.setTotal(false);
        uccMsearchEsDayReqBO.setQuery(queryDay);
        for (String each : reqBO.getMenuCode()) {
            if (menuInfoMap.containsKey(each)) {
                BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)menuInfoMap.get(each).getSkuSource()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"spu_approval_status", (Collection)menuInfoMap.get(each).getApprovalStatus()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)menuInfoMap.get(each).getSkuStaus()));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", stationIds));
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"audit_time").gte((Object)today));
                JSONObject queryJson = new JSONObject();
                JSONObject aggs = new JSONObject();
                JSONObject cardinality = new JSONObject();
                JSONObject field = new JSONObject();
                if (menuInfoMap.get(each).getType() == 0) {
                    field.put("field", (Object)"commodity_id");
                } else {
                    field.put("field", (Object)"sku_id");
                }
                cardinality.put("cardinality", (Object)field);
                aggs.put("cardinality_count", (Object)cardinality);
                queryJson.put("aggs", (Object)aggs);
                queryJson.put("query", (Object)JSONObject.parseObject((String)extBoolQueryBuilder.toString().replace("\\n", "").replace(" ", "")));
                queryJson.put("size", (Object)1);
                queryJson.put("from", (Object)1);
                queryDay.add(queryJson.toString());
                continue;
            }
            throw new BusinessException(RspConstantEnums.MEM_WAIT_DONE_EXIST.code(), RspConstantEnums.MEM_WAIT_DONE_EXIST.message());
        }
        UccMsearchEsRspBO uccMsearchEsRspBONormal = this.uccMsearchEsService.mSearch(uccMsearchEsNormalReqBO);
        UccMsearchEsRspBO uccMsearchEsRspBODay = this.uccMsearchEsService.mSearch(uccMsearchEsDayReqBO);
        if (!"0000".equals(uccMsearchEsRspBONormal.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMsearchEsRspBONormal), (Object)rspBO);
            return rspBO;
        }
        if (!"0000".equals(uccMsearchEsRspBODay.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMsearchEsRspBONormal), (Object)rspBO);
            return rspBO;
        }
        if (CollectionUtils.isEmpty(uccMsearchEsRspBONormal.getRows()) || CollectionUtils.isEmpty(uccMsearchEsRspBODay.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Integer count = 0;
        Integer dayCout = 0;
        ArrayList<DycUccWaitDoneDetailBO> waitDoneDetailBOS = new ArrayList<DycUccWaitDoneDetailBO>();
        for (int i = 0; i < reqBO.getMenuCode().size(); ++i) {
            DycUccWaitDoneDetailBO uccWaitDoneDetailBO = new DycUccWaitDoneDetailBO();
            if (!CollectionUtils.isEmpty(uccMsearchEsRspBONormal.getRows()) && uccMsearchEsRspBONormal.getRows().get(i) != null) {
                count = count + uccMsearchEsRspBONormal.getRows().get(i).getTotal();
                uccWaitDoneDetailBO.setItemDetailTotal(uccMsearchEsRspBONormal.getRows().get(i).getTotal());
            }
            if (!CollectionUtils.isEmpty(uccMsearchEsRspBODay.getRows()) && uccMsearchEsRspBODay.getRows().get(i) != null) {
                dayCout = dayCout + uccMsearchEsRspBODay.getRows().get(i).getTotal();
                uccWaitDoneDetailBO.setTodayItemDetailTotal(uccMsearchEsRspBODay.getRows().get(i).getTotal());
            }
            uccWaitDoneDetailBO.setItemDetailName(menuInfoMap.get(reqBO.getMenuCode().get(i)).getMeunName());
            uccWaitDoneDetailBO.setUrl(menuInfoMap.get(reqBO.getMenuCode().get(i)).getMeunCode());
            waitDoneDetailBOS.add(uccWaitDoneDetailBO);
        }
        rspBO.setItemDetailTotal(count);
        rspBO.setTodayItemDetailTotal(dayCout);
        rspBO.setRows(waitDoneDetailBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static void initialize() {
        UccMemWatiDoneRuleBO eCommerce2001 = new UccMemWatiDoneRuleBO();
        eCommerce2001.setSkuStaus(new ArrayList<Integer>(Arrays.asList(2)));
        eCommerce2001.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(21)));
        eCommerce2001.setSkuSource(Integer.valueOf(2));
        eCommerce2001.setType(Integer.valueOf(1));
        eCommerce2001.setMeunCode("ecCommodityApprovalList");
        eCommerce2001.setMeunName("\u5f85\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2001", eCommerce2001);
        UccMemWatiDoneRuleBO eCommerce2002 = new UccMemWatiDoneRuleBO();
        eCommerce2002.setSkuStaus(new ArrayList<Integer>(Arrays.asList(8)));
        eCommerce2002.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(41)));
        eCommerce2002.setSkuSource(Integer.valueOf(2));
        eCommerce2002.setType(Integer.valueOf(1));
        eCommerce2002.setMeunCode("ecCommodityApprovalList");
        eCommerce2002.setMeunName("\u5f85\u4e0b\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2002", eCommerce2002);
        UccMemWatiDoneRuleBO eCommerce2003 = new UccMemWatiDoneRuleBO();
        eCommerce2003.setSkuStaus(new ArrayList<Integer>(Arrays.asList(10, 5)));
        eCommerce2003.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(51)));
        eCommerce2003.setSkuSource(Integer.valueOf(2));
        eCommerce2003.setType(Integer.valueOf(1));
        eCommerce2003.setMeunCode("ecCommodityApprovalList");
        eCommerce2003.setMeunName("\u5f85\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2003", eCommerce2003);
        UccMemWatiDoneRuleBO agr2004 = new UccMemWatiDoneRuleBO();
        agr2004.setSkuStaus(new ArrayList<Integer>(Arrays.asList(0)));
        agr2004.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(31)));
        agr2004.setSkuSource(Integer.valueOf(3));
        agr2004.setType(Integer.valueOf(0));
        agr2004.setMeunCode("agrApprovalList");
        agr2004.setMeunName("\u5f85\u7f16\u8f91\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2004", eCommerce2003);
        UccMemWatiDoneRuleBO agr2005 = new UccMemWatiDoneRuleBO();
        agr2005.setSkuStaus(new ArrayList<Integer>(Arrays.asList(2)));
        agr2005.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(21)));
        agr2005.setSkuSource(Integer.valueOf(3));
        agr2005.setType(Integer.valueOf(1));
        agr2005.setMeunCode("agrApprovalList");
        agr2005.setMeunName("\u5f85\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2005", agr2005);
        UccMemWatiDoneRuleBO agr2006 = new UccMemWatiDoneRuleBO();
        agr2006.setSkuStaus(new ArrayList<Integer>(Arrays.asList(8)));
        agr2006.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(41)));
        agr2006.setSkuSource(Integer.valueOf(3));
        agr2006.setType(Integer.valueOf(1));
        agr2006.setMeunCode("agrApprovalList");
        agr2006.setMeunName("\u5f85\u4e0b\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2006", agr2006);
        UccMemWatiDoneRuleBO agr2007 = new UccMemWatiDoneRuleBO();
        agr2007.setSkuStaus(new ArrayList<Integer>(Arrays.asList(10, 5)));
        agr2007.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(51)));
        agr2007.setSkuSource(Integer.valueOf(3));
        agr2007.setType(Integer.valueOf(1));
        agr2007.setMeunCode("agrApprovalList");
        agr2007.setMeunName("\u5f85\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2007", agr2007);
        UccMemWatiDoneRuleBO agr2008 = new UccMemWatiDoneRuleBO();
        agr2008.setSkuStaus(new ArrayList<Integer>(Arrays.asList(0)));
        agr2008.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(31)));
        agr2008.setSkuSource(Integer.valueOf(1));
        agr2008.setType(Integer.valueOf(0));
        agr2008.setMeunCode("unagrApprovalList");
        agr2008.setMeunName("\u5f85\u7f16\u8f91\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2008", agr2008);
        UccMemWatiDoneRuleBO agr2009 = new UccMemWatiDoneRuleBO();
        agr2009.setSkuStaus(new ArrayList<Integer>(Arrays.asList(0)));
        agr2009.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(31)));
        agr2009.setSkuSource(Integer.valueOf(1));
        agr2009.setType(Integer.valueOf(1));
        agr2009.setMeunCode("unagrApprovalList");
        agr2009.setMeunName("\u5f85\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2009", agr2009);
        UccMemWatiDoneRuleBO agr2010 = new UccMemWatiDoneRuleBO();
        agr2010.setSkuStaus(new ArrayList<Integer>(Arrays.asList(8)));
        agr2010.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(41)));
        agr2010.setSkuSource(Integer.valueOf(1));
        agr2010.setType(Integer.valueOf(1));
        agr2010.setMeunCode("unagrApprovalList");
        agr2010.setMeunName("\u5f85\u4e0b\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2010", agr2010);
        UccMemWatiDoneRuleBO agr2011 = new UccMemWatiDoneRuleBO();
        agr2011.setSkuStaus(new ArrayList<Integer>(Arrays.asList(10, 5)));
        agr2011.setApprovalStatus(new ArrayList<Integer>(Arrays.asList(51)));
        agr2011.setSkuSource(Integer.valueOf(1));
        agr2011.setType(Integer.valueOf(1));
        agr2011.setMeunCode("unagrApprovalList");
        agr2011.setMeunName("\u5f85\u6062\u590d\u4e0a\u67b6\u5ba1\u6279\u5546\u54c1");
        menuInfoMap.put("2011", agr2011);
    }

    static {
        DycUccMemWaitDoneDetailListQryAbilityServiceImpl.initialize();
    }
}

