/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallBatchShopingQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccBatchShopQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopQryMsgBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityRspBO;
import com.tydic.commodity.mall.dao.UccMallOrgSkuMapper;
import com.tydic.commodity.mall.po.UccMallBatchShopQryMsgPO;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallBatchShopingQryAbilityService"})
public class UccMallBatchShopingQryAbilityServiceImpl
implements UccMallBatchShopingQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallBatchShopingQryAbilityServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccMallBatchShopingQryAbilityServiceImpl.class);
    @Autowired
    private UccMallOrgSkuMapper uccMallOrgSkuMapper;

    @PostMapping(value={"qryInfo"})
    public UccMallBatchShopingQryAbilityRspBO qryInfo(@RequestBody UccMallBatchShopingQryAbilityReqBO reqBo) {
        UccMallBatchShopingQryAbilityRspBO rspBo = new UccMallBatchShopingQryAbilityRspBO();
        if (reqBo.getShopQry() == null || reqBo.getShopQry().size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5355\u54c1ID \u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBo;
        }
        List<Long> skuIds = reqBo.getShopQry().stream().map(UccBatchShopQryBo::getSkuId).collect(Collectors.toList());
        List<UccMallBatchShopQryMsgPO> uccMallBatchShopQryMsgPOS = this.uccMallOrgSkuMapper.qryShoppingSkuList(skuIds);
        if (CollectionUtils.isEmpty(uccMallBatchShopQryMsgPOS)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1ID!");
            return rspBo;
        }
        ArrayList<UccMallBatchShopQryMsgBo> shopQryMsg = new ArrayList<UccMallBatchShopQryMsgBo>();
        for (UccMallBatchShopQryMsgPO uccMallBatchShopQryMsgPO : uccMallBatchShopQryMsgPOS) {
            UccMallBatchShopQryMsgBo bo = new UccMallBatchShopQryMsgBo();
            BeanUtils.copyProperties((Object)uccMallBatchShopQryMsgPO, (Object)bo);
            for (UccBatchShopQryBo uccBatchShopQryBo : reqBo.getShopQry()) {
                if (!bo.getSkuId().equals(uccBatchShopQryBo.getSkuId())) continue;
                bo.setSaleNum(uccBatchShopQryBo.getSaleNum());
            }
            bo.setAvailableSale(Integer.valueOf(1));
            if (uccMallBatchShopQryMsgPO.getStock() == null || uccMallBatchShopQryMsgPO.getStock() == 0) {
                bo.setAvailableSale(Integer.valueOf(0));
                bo.setNoAvailableSaleDesc("\u5e93\u5b58\u4e0d\u8db3");
            }
            if (!StringUtils.isEmpty((Object)reqBo.getProvince()) || reqBo.getOrgId() != null) {
                // empty if block
            }
            bo.setPrice(MoneyUtils.haoToYuan(bo.getPrice()));
            bo.setStock(Integer.valueOf(MoneyUtils.haoToYuan(new BigDecimal(bo.getStock())).intValue()));
            shopQryMsg.add(bo);
        }
        rspBo.setShopQryMsg(shopQryMsg);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

