/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.mall.ability.api.UccMallSearchBuildAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallOrderColumBo;
import com.tydic.commodity.mall.ability.bo.UccMallSeTermsBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBuildAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBuildAbilityRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchOrderConfigBO;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSearchBuildAbilityService"})
public class UccMallSearchBuildAbilityServiceImpl
implements UccMallSearchBuildAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchBuildAbilityServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"build"})
    public UccMallSearchBuildAbilityRspBO build(@RequestBody UccMallSearchBuildAbilityReqBO reqBO) {
        UccMallSeTermsBO assortBO;
        UccMallSeTermsBO verdorBO;
        UccMallSeTermsBO typeIdBO;
        ArrayList<String> valueList;
        UccMallSearchBuildAbilityRspBO rspBO = new UccMallSearchBuildAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setQueryStr(reqBO.getQueryStr());
        if (reqBO.getMaxSalesPrice() != null) {
            rspBO.setMaxSalePrice(MoneyUtils.yuanToHao(reqBO.getMaxSalesPrice()).toString());
        }
        if (reqBO.getMinSalesPrice() != null) {
            rspBO.setMinSalePrice(MoneyUtils.yuanToHao(reqBO.getMinSalesPrice()).toString());
        }
        ArrayList<UccMallSeTermsBO> mustTermsList = new ArrayList<UccMallSeTermsBO>();
        ArrayList<UccMallSeTermsBO> mustNotTermsList = new ArrayList<UccMallSeTermsBO>();
        String orgPath = reqBO.getOrgPath();
        List<Object> ignoeList = new ArrayList();
        if (!StringUtils.isEmpty((Object)reqBO.getOrgPath())) {
            ignoeList = this.searchLimitGui(orgPath);
        }
        ArrayList<UccMallOrderColumBo> orderColum = new ArrayList<UccMallOrderColumBo>();
        if (reqBO.getOrderByColumn() != null && reqBO.getOrderByColumn() != 0) {
            String sortField = "";
            if (reqBO.getOrderByColumn() != null) {
                if (reqBO.getOrderByColumn() == 1) {
                    sortField = "sold_number";
                } else if (reqBO.getOrderByColumn() == 2) {
                    sortField = "on_shelve_time";
                } else if (reqBO.getOrderByColumn() == 3) {
                    sortField = "sale_price";
                } else if (reqBO.getOrderByColumn() == 4) {
                    sortField = "discounts";
                } else if (reqBO.getOrderByColumn() == 5) {
                    sortField = "comment_number";
                }
            }
            if (!StringUtils.isEmpty((Object)sortField)) {
                UccMallOrderColumBo bo = new UccMallOrderColumBo();
                bo.setOrderByColumn(sortField);
                bo.setOrderType(reqBO.getOrderType());
                orderColum.add(bo);
                rspBO.setComSortList(orderColum);
            }
        } else {
            Object obj = null;
            obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG" + reqBO.getQueryChannelId());
            if (obj == null) {
                obj = this.cacheClient.get("UCC_SKU_SEARCH_ORDER_CONFIG");
            }
            if (obj != null) {
                List<UccMallSearchOrderConfigBO> searchOrderConfigBoList = new ArrayList();
                try {
                    searchOrderConfigBoList = obj instanceof String ? JSONObject.parseArray((String)((String)obj), UccMallSearchOrderConfigBO.class) : JSONObject.parseArray((String)JSONObject.toJSONString((Object)obj), UccMallSearchOrderConfigBO.class);
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a\u5546\u54c1\u6392\u5e8f\u8f6c\u6362\u5f02\u5e38" + JSONObject.toJSONString((Object)reqBO));
                }
                if (!CollectionUtils.isEmpty(searchOrderConfigBoList)) {
                    searchOrderConfigBoList.sort(Comparator.comparing(UccMallSearchOrderConfigBO::getId));
                    for (UccMallSearchOrderConfigBO each : searchOrderConfigBoList) {
                        if (each.getStatus() != 1L) continue;
                        UccMallOrderColumBo bo = new UccMallOrderColumBo();
                        bo.setOrderByColumn(each.getColName());
                        bo.setOrderType(Integer.valueOf(each.getType().intValue()));
                        orderColum.add(bo);
                    }
                    rspBO.setComSortList(orderColum);
                }
            }
        }
        if (reqBO.getSkuStatus() == null || reqBO.getSkuStatus().size() == 0) {
            ArrayList<String> skuStatus = new ArrayList<String>();
            skuStatus.add(ModelRuleConstant.SKU_STATUS_ON_SHELF.toString());
            UccMallSeTermsBO statusBO = new UccMallSeTermsBO();
            statusBO.setName("sku_status");
            statusBO.setValueList(skuStatus);
            mustTermsList.add(statusBO);
        }
        if (reqBO.getCategoryId() != null && reqBO.getLevel() != null) {
            UccMallSeTermsBO categoryIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList<String>();
            valueList.add(reqBO.getCategoryId().toString());
            if (reqBO.getLevel() == 1) {
                categoryIdBO.setName("l1_category_id");
            }
            if (reqBO.getLevel() == 2) {
                categoryIdBO.setName("l2_category_id");
            }
            if (reqBO.getLevel() == 3) {
                categoryIdBO.setName("l3_category_id");
            }
            categoryIdBO.setValueList(valueList);
            mustTermsList.add(categoryIdBO);
        }
        if (reqBO.getCommodityType() != null) {
            UccMallSeTermsBO commodityTypeBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getCommodityType().toString());
            commodityTypeBO.setName("commodity_type");
            commodityTypeBO.setValueList(valueList);
            mustTermsList.add(commodityTypeBO);
        }
        if (reqBO.getBrandId() != null) {
            UccMallSeTermsBO brandIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getBrandId().toString());
            brandIdBO.setName("brand_id");
            brandIdBO.setValueList(valueList);
            mustTermsList.add(brandIdBO);
        }
        if (reqBO.getTypeId() != null) {
            typeIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getTypeId().toString());
            typeIdBO.setName("type_id");
            typeIdBO.setValueList(valueList);
            mustTermsList.add(typeIdBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTypeIds())) {
            typeIdBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getTypeIds().forEach(a -> valueList.add(a.toString()));
            typeIdBO.setName("type_id");
            typeIdBO.setValueList(valueList);
            mustTermsList.add(typeIdBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTypeName())) {
            UccMallSeTermsBO typeNameBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getTypeName());
            typeNameBO.setName("type_name");
            typeNameBO.setValueList(valueList);
            mustTermsList.add(typeNameBO);
        }
        if (reqBO.getQueryChannelId() != null) {
            UccMallSeTermsBO channelBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getQueryChannelId().toString());
            channelBO.setName("channel_id");
            channelBO.setValueList(valueList);
            mustTermsList.add(channelBO);
        }
        if (reqBO.getSupplierShopId() != null) {
            UccMallSeTermsBO shopBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getSupplierShopId().toString());
            shopBO.setName("supplier_shop_id");
            shopBO.setValueList(valueList);
            mustTermsList.add(shopBO);
        }
        if (reqBO.getSupplierId() != null) {
            UccMallSeTermsBO suppllierBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getSupplierId().toString());
            suppllierBO.setName("supplier_id");
            suppllierBO.setValueList(valueList);
            mustTermsList.add(suppllierBO);
        }
        if (reqBO.getVendorId() != null) {
            verdorBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getVendorId().toString());
            verdorBO.setName("vendor_id");
            verdorBO.setValueList(valueList);
            mustTermsList.add(verdorBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAgreementId())) {
            verdorBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getAgreementId());
            verdorBO.setName("agreement_id");
            verdorBO.setValueList(valueList);
            mustTermsList.add(verdorBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuList())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getSkuList().forEach(a -> valueList.add(a.toString()));
            assortBO.setName("sku_id");
            assortBO.setValueList(valueList);
            mustTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtSkuIds())) {
            assortBO = new UccMallSeTermsBO();
            assortBO.setName("ext_sku_id");
            assortBO.setValueList(reqBO.getExtSkuIds());
            mustTermsList.add(assortBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUpcCode())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            valueList.add(reqBO.getUpcCode());
            assortBO.setName("upc");
            assortBO.setValueList(valueList);
            mustTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSourceAssort())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getSourceAssort().forEach(a -> valueList.add(a.toString()));
            valueList.add(reqBO.getVendorId().toString());
            assortBO.setName("sourceAssort");
            assortBO.setValueList(valueList);
            mustTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreList())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreList().forEach(a -> valueList.add(a.toString()));
            assortBO.setName("sku_id");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getSupplierIds().forEach(a -> valueList.add(a.toString()));
            assortBO.setName("supplier_id");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreAgrList()) || !CollectionUtils.isEmpty(ignoeList)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getIgnoreAgrList())) {
                reqBO.setIgnoreAgrList(ignoeList);
            } else if (!CollectionUtils.isEmpty(ignoeList)) {
                reqBO.getIgnoreAgrList().addAll(ignoeList);
            }
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreAgrList().forEach(a -> valueList.add(a.toString()));
            assortBO.setName("agreement_id");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreSourceAssort())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreSourceAssort().forEach(a -> valueList.add(a.toString()));
            valueList.add(reqBO.getVendorId().toString());
            assortBO.setName("sourceAssort");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getIgnoreCommdList())) {
            assortBO = new UccMallSeTermsBO();
            valueList = new ArrayList();
            reqBO.getIgnoreCommdList().forEach(a -> valueList.add(a.toString()));
            valueList.add(reqBO.getVendorId().toString());
            assortBO.setName("commodity_id");
            assortBO.setValueList(valueList);
            mustNotTermsList.add(assortBO);
        }
        rspBO.setMustNotTermsList(mustNotTermsList);
        rspBO.setMustTermsList(mustTermsList);
        return rspBO;
    }

    public List<Long> searchLimitGui(String orgPath) {
        ArrayList<Long> igSkuList = new ArrayList<Long>();
        ArrayList whiteList = new ArrayList();
        if (StringUtils.isEmpty((Object)orgPath)) {
            return null;
        }
        String[] orgPathList = orgPath.split("-");
        HashedMap igListMap = new HashedMap();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orgPathList.length; ++i) {
            sb = new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION");
            String sb1 = sb.append(orgPathList[i]).toString();
            Object object = this.cacheClient.get(sb1);
            if (object == null || !(object instanceof ArrayList)) continue;
            for (Object o : (List)object) {
                whiteList.add(Long.class.cast(o));
            }
        }
        Object object = this.cacheClient.get("UCC_ORG_AGR_EXCLUDE_RESTRICTION");
        if (object instanceof ArrayList) {
            for (Object o : (List)object) {
                igSkuList.add((Long)Long.class.cast(o));
            }
        }
        if (CollectionUtils.isEmpty(igSkuList) || CollectionUtils.isEmpty(whiteList)) {
            return igSkuList;
        }
        igSkuList.removeAll(whiteList);
        return igSkuList;
    }
}

