/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.mall.ability.api.UccMallSearchBarEsAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallSpuDetailSkuListAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.mall.ability.bo.UccMallSpuDetailSkuListAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuDetailSkuListAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuDetailSkuListBO;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccSkuSpecMapper;
import com.tydic.commodity.mall.po.Prop;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallSpuDetailSkuListAbilityService"})
public class UccMallSpuDetailSkuListAbilityServiceImpl
implements UccMallSpuDetailSkuListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSpuDetailSkuListAbilityServiceImpl.class);
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccMallSearchBarEsAbilityService uccMallSearchBarEsAbilityService;
    @Autowired
    private UccMallLadderPriceMapper uccMallLadderPriceMapper;

    @PostMapping(value={"getSpuDetailSkuList"})
    public UccMallSpuDetailSkuListAbilityRspBO getSpuDetailSkuList(@RequestBody UccMallSpuDetailSkuListAbilityReqBO reqBO) {
        UccMallSpuDetailSkuListAbilityRspBO rspBO = new UccMallSpuDetailSkuListAbilityRspBO();
        if (reqBO == null || reqBO.getCommodityId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u67e5\u8be2\u6570\u636e\u5185\u5bb9");
            return rspBO;
        }
        ArrayList commodityPropDefIds = new ArrayList();
        HashSet commodityPropDefIdSets = new HashSet();
        ArrayList propValueListIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList())) {
            reqBO.getQryInfoList().stream().forEach(item -> {
                commodityPropDefIdSets.add(item.getCommodityPropDefId());
                commodityPropDefIds.add(item.getCommodityPropDefId());
                propValueListIds.add(item.getPropValueListId());
            });
        }
        if (commodityPropDefIds.size() != commodityPropDefIds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7b5b\u9009\u5185\u5bb9\u4e0d\u5339\u914d");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        ArrayList<Prop> props = new ArrayList<Prop>();
        commodityPropDefIdSets.stream().forEach(item -> {
            Prop prop = new Prop();
            prop.setPropId((Long)item);
            List<Long> values = reqBO.getQryInfoList().stream().filter(e -> e.getCommodityPropDefId().equals(item)).map(e -> e.getPropValueListId()).collect(Collectors.toList());
            prop.setPropValueIds(values);
            props.add(prop);
        });
        List<Long> skus = this.uccSkuSpecMapper.qrySKuFilterSpecTwo(reqBO.getCommodityId(), props, reqBO.getSkuName(), page);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        if (!CollectionUtils.isEmpty(skus)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getQryInfoList()) && StringUtils.isEmpty((Object)reqBO.getSkuName()) && skus.size() == 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRecordsTotal(0);
                rspBO.setTotal(0);
                return rspBO;
            }
            UccMallSearchBarEsReqBO uccMallSearchBarEsReqBO = new UccMallSearchBarEsReqBO();
            uccMallSearchBarEsReqBO.setSkuList(skus);
            uccMallSearchBarEsReqBO.setField(false);
            uccMallSearchBarEsReqBO.setPageSize(reqBO.getPageSize());
            UccMallSearchBarEsRspBO uccMallSearchBarEsRspBO = this.uccMallSearchBarEsAbilityService.qryBySearchBar(uccMallSearchBarEsReqBO);
            if (uccMallSearchBarEsRspBO != null && !CollectionUtils.isEmpty((Collection)uccMallSearchBarEsRspBO.getResult())) {
                List<UccLadderPricePO> uccLadderPricePOS;
                ArrayList<Long> ladderSku = new ArrayList<Long>();
                ArrayList<UccMallSpuDetailSkuListBO> reslut = new ArrayList<UccMallSpuDetailSkuListBO>();
                for (UccMallSearchBarEsRspInfo each : uccMallSearchBarEsRspBO.getResult()) {
                    UccMallSpuDetailSkuListBO uccMallSpuDetailSkuListBO = new UccMallSpuDetailSkuListBO();
                    BeanUtils.copyProperties((Object)each, (Object)uccMallSpuDetailSkuListBO);
                    if (null != each.getCommentNumber()) {
                        uccMallSpuDetailSkuListBO.setStock(MoneyUtils.haoToYuan(each.getCommentNumber()));
                    }
                    uccMallSpuDetailSkuListBO.setSkuId(each.getSkuId());
                    uccMallSpuDetailSkuListBO.setSkuSource(each.getSkuSource());
                    uccMallSpuDetailSkuListBO.setVendorId(each.getVendorId());
                    uccMallSpuDetailSkuListBO.setCommodityTypeId(each.getTypeId());
                    uccMallSpuDetailSkuListBO.setAgreementPrice(each.getAgreementPrice());
                    uccMallSpuDetailSkuListBO.setSalePrice(each.getSalePrice());
                    if (!StringUtils.isEmpty((Object)each.getPriPicUrl())) {
                        uccMallSpuDetailSkuListBO.setSkuPicUrl(each.getPriPicUrl());
                    } else {
                        uccMallSpuDetailSkuListBO.setSkuPicUrl(each.getCommdPicUrl());
                    }
                    if (each.getSwitchOn() == 1) {
                        ladderSku.add(each.getSkuId());
                    }
                    reslut.add(uccMallSpuDetailSkuListBO);
                }
                if (!CollectionUtils.isEmpty(ladderSku) && !CollectionUtils.isEmpty(uccLadderPricePOS = this.uccMallLadderPriceMapper.selectBySkuIds(ladderSku, null))) {
                    Map<Long, List<UccLadderPricePO>> skuLadderMap = uccLadderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                    for (UccMallSpuDetailSkuListBO uccMallSpuDetailSkuListBO : reslut) {
                        if (!skuLadderMap.containsKey(uccMallSpuDetailSkuListBO.getSkuId())) continue;
                        ((List)skuLadderMap.get(uccMallSpuDetailSkuListBO.getSkuId())).stream().sorted(Comparator.comparing(UccLadderPricePO::getStart));
                        ArrayList ladderPrice = new ArrayList();
                        ((List)skuLadderMap.get(uccMallSpuDetailSkuListBO.getSkuId())).forEach(a -> {
                            UccMallLadderPriceBo priceBo = new UccMallLadderPriceBo();
                            priceBo.setDiscount(a.getDiscount());
                            priceBo.setPrice(MoneyUtils.haoToYuan(a.getPrice()));
                            priceBo.setStartPrice(MoneyUtils.haoToYuan(a.getStart()));
                            if (a.getStop() != null) {
                                priceBo.setStopPrice(MoneyUtils.haoToYuan(a.getStop()));
                            }
                            ladderPrice.add(priceBo);
                        });
                        uccMallSpuDetailSkuListBO.setLadderPrice(ladderPrice);
                    }
                }
                if (reqBO.getCommodityId() != null && "1".equals(reqBO.getIsprofess())) {
                    ArrayList<ReplacePriceInfoBO> replacePriceInfo = new ArrayList<ReplacePriceInfoBO>();
                    for (UccMallSpuDetailSkuListBO uccMallSpuDetailSkuListBO : reslut) {
                        ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                        replacePriceInfoBO.setSkuSource(uccMallSpuDetailSkuListBO.getSkuSource());
                        replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(uccMallSpuDetailSkuListBO.getSalePrice())));
                        replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(uccMallSpuDetailSkuListBO.getAgreementPrice())));
                        replacePriceInfoBO.setLadderPrice(uccMallSpuDetailSkuListBO.getLadderPrice());
                        replacePriceInfoBO.setSkuId(uccMallSpuDetailSkuListBO.getSkuId());
                        replacePriceInfoBO.setCommodityTypeId(uccMallSpuDetailSkuListBO.getCommodityTypeId());
                        replacePriceInfoBO.setVendorId(uccMallSpuDetailSkuListBO.getVendorId());
                        replacePriceInfoBO.setSupplierShopId(uccMallSpuDetailSkuListBO.getSupplierShopId());
                        replacePriceInfoBO.setCommodityId(reqBO.getCommodityId());
                        replacePriceInfo.add(replacePriceInfoBO);
                    }
                    UccMallReplacementPriceReqBo replacementPriceReqBo = new UccMallReplacementPriceReqBo();
                    replacementPriceReqBo.setReplacePriceInfo(replacePriceInfo);
                    replacementPriceReqBo.setIsprofess(reqBO.getIsprofess());
                    replacementPriceReqBo.setCompanyId(reqBO.getCompanyId());
                    UccMallReplacementPriceRspBo uccMallReplacementPriceRspBo = new UccMallReplacementPriceRspBo();
                    if ("0000".equals(uccMallReplacementPriceRspBo.getRespCode())) {
                        if (!CollectionUtils.isEmpty((Collection)uccMallReplacementPriceRspBo.getRows())) {
                            Map map = uccMallReplacementPriceRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, Function.identity()));
                            for (UccMallSpuDetailSkuListBO uccMallSpuDetailSkuListBO : reslut) {
                                if (!map.containsKey(uccMallSpuDetailSkuListBO.getSkuId())) continue;
                                uccMallSpuDetailSkuListBO.setSalePrice(MoneyUtils.haoToYuan(((ReplacePriceInfoBO)map.get(uccMallSpuDetailSkuListBO.getSkuId())).getSalePrice()));
                                uccMallSpuDetailSkuListBO.setLadderPrice(((ReplacePriceInfoBO)map.get(uccMallSpuDetailSkuListBO.getSkuId())).getLadderPrice());
                            }
                        }
                    } else {
                        log.error("\u4ef7\u683c\u66ff\u6362\u5f02\u5e38\uff1a" + uccMallReplacementPriceRspBo.getRespDesc());
                    }
                }
                rspBO.setRows(reslut);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

