/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallActivityCenterSearchEsService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallActivityCenterSearchEsReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallActivityCenterSearchEsRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.mall.busi.api.UccMallSearchCommodityService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallActivityCenterSearchEsService"})
public class UccMallActivityCenterSearchEsServiceImpl
implements UccMallActivityCenterSearchEsService {
    private static final Logger log = LoggerFactory.getLogger(UccMallActivityCenterSearchEsServiceImpl.class);
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(UccMallActivityCenterSearchEsServiceImpl.class);
    @Autowired
    private UccMallSearchCommodityService uccMallSearchCommodityService;
    private static Integer esSeaarchSize = 10000;

    @PostMapping(value={"qryBySearchBar"})
    public UccMallActivityCenterSearchEsRspBO qryBySearchBar(@RequestBody UccMallActivityCenterSearchEsReqBO reqBo) {
        UccMallActivityCenterSearchEsRspBO rspBO;
        block12: {
            block11: {
                rspBO = new UccMallActivityCenterSearchEsRspBO();
                if (reqBo.getSkuList() != null && reqBo.getIgnoreList() != null && reqBo.getSkuList().size() > 0 && reqBo.getIgnoreList().size() > 0) {
                    rspBO.setRespCode(UccMallConstantsEnums.QUERIES_CANNOT_BE_FILTERED.code());
                    rspBO.setRespDesc("\u4e0d\u80fd\u540c\u65f6\u8fc7\u6ee4\u67e5\u8be2");
                    return rspBO;
                }
                UccMallSearchEsReqBO searchEsReqBO = new UccMallSearchEsReqBO();
                BeanUtils.copyProperties((Object)reqBo, (Object)((Object)searchEsReqBO));
                UccMallSearchEsRspBo searchEsRspBo = this.uccMallSearchCommodityService.queryByMatch(searchEsReqBO);
                if (searchEsRspBo == null) {
                    LOGGER.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
                    rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
                    rspBO.setPageNo(1);
                    rspBO.setTotal(0);
                    rspBO.setRecordsTotal(0);
                    return rspBO;
                }
                BeanUtils.copyProperties((Object)reqBo, (Object)rspBO);
                List<UccMallCommodityRspBo> commodityRspBos = searchEsRspBo.getUccMallCommodityRspBos();
                List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
                rspBO.setResult(result);
                int size = reqBo.getPageSize();
                int no = reqBo.getPageNo();
                int totalPage = 0;
                int add = 0;
                Integer total = 0;
                if (esSeaarchSize.compareTo(searchEsRspBo.getTotal()) > 0) {
                    totalPage = searchEsRspBo.getTotal() / size;
                    add = searchEsRspBo.getTotal() % size == 0 ? 0 : 1;
                    total = searchEsRspBo.getTotal();
                } else {
                    totalPage = esSeaarchSize / size;
                    total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
                    if (total.compareTo(searchEsRspBo.getTotal()) > 0) {
                        total = searchEsRspBo.getTotal();
                    }
                }
                rspBO.setTotal(totalPage + add);
                rspBO.setPageNo(no);
                if (searchEsRspBo.getUccMallQueryParams() != null && searchEsRspBo.getPropParams() != null) {
                    searchEsRspBo.getUccMallQueryParams().addAll(searchEsRspBo.getPropParams());
                }
                rspBO.setRecordsTotal(total.intValue());
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
                if (!"1".equals(reqBo.getIsprofess()) || "".equals(reqBo.getCompanyId()) || StringUtils.isEmpty((Object)rspBO.getResult()) || reqBo.isWelfare()) break block11;
                UccMallReplacementPriceReqBo cnncReplacementPriceBusiReqBo = new UccMallReplacementPriceReqBo();
                ReplacePriceInfoBO replacePriceInfoBO = null;
                ArrayList<ReplacePriceInfoBO> replacePriceInfoBOList = new ArrayList<ReplacePriceInfoBO>();
                for (UccMallSearchBarEsRspInfo each : rspBO.getResult()) {
                    replacePriceInfoBO = new ReplacePriceInfoBO();
                    replacePriceInfoBO.setCommodityTypeId(each.getTypeId());
                    replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(each.getAgreementPrice())));
                    replacePriceInfoBO.setSkuSource(each.getSkuSource());
                    replacePriceInfoBO.setSupplierShopId(each.getSupplierShopId());
                    replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong(each.getSalePrice())));
                    replacePriceInfoBO.setSkuId(each.getSkuId());
                    replacePriceInfoBO.setCommodityId(each.getCommodityId());
                    replacePriceInfoBO.setAgreementId(each.getAgreementId());
                    replacePriceInfoBO.setVendorId(each.getVendorId());
                    replacePriceInfoBOList.add(replacePriceInfoBO);
                }
                cnncReplacementPriceBusiReqBo.setIsprofess(reqBo.getIsprofess());
                cnncReplacementPriceBusiReqBo.setCompanyId(reqBo.getCompanyId());
                cnncReplacementPriceBusiReqBo.setReplacePriceInfo(replacePriceInfoBOList);
                cnncReplacementPriceBusiReqBo.setPsDiscountRate(reqBo.getPsDiscountRate());
                UccMallReplacementPriceRspBo cnncReplacementPriceBusiRspBo = new UccMallReplacementPriceRspBo();
                if (!"0000".equals(cnncReplacementPriceBusiRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncReplacementPriceBusiRspBo.getRows())) break block12;
                Map<Long, Long> replacePriceMap = cnncReplacementPriceBusiRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, ReplacePriceInfoBO::getSalePrice));
                for (UccMallSearchBarEsRspInfo each : rspBO.getResult()) {
                    if (!replacePriceMap.containsKey(each.getSkuId())) continue;
                    each.setSalePrice(MoneyUtils.haoToYuan(replacePriceMap.get(each.getSkuId())));
                }
                break block12;
            }
            for (UccMallSearchBarEsRspInfo each : rspBO.getResult()) {
                if (!"2".equals(reqBo.getIsprofess()) || each.getSourceAssort() == null || each.getSourceAssort() != 0 && each.getSourceAssort() != 3 || each.getAgreementPrice() == null) continue;
                each.setSalePrice(each.getAgreementPrice());
            }
            if (reqBo.getPsDiscountRate() != null && reqBo.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
                for (UccMallSearchBarEsRspInfo each : rspBO.getResult()) {
                    if (each.getSalePrice().compareTo(each.getAgreementPrice()) == 0) continue;
                    BigDecimal difValue = each.getSalePrice().subtract(each.getAgreementPrice());
                    BigDecimal salePirce = difValue.multiply(reqBo.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 0)).add(each.getAgreementPrice());
                    each.setSalePrice(salePirce);
                }
            }
        }
        return rspBO;
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> commodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo commodityRspBo : commodityRspBos) {
                UccMallSearchBarEsRspInfo searchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setL1CategoryId(commodityRspBo.getL1_category_id());
                searchBarEsRspInfo.setL2CategoryId(commodityRspBo.getL2_category_id());
                searchBarEsRspInfo.setL3CategoryId(commodityRspBo.getL3_category_id());
                searchBarEsRspInfo.setL1CategoryName(commodityRspBo.getL1_category_name());
                searchBarEsRspInfo.setL2CategoryName(commodityRspBo.getL2_category_name());
                searchBarEsRspInfo.setL3CategoryName(commodityRspBo.getL3_category_name());
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setViewOrder(Integer.valueOf(commodityRspBo.getView_order()));
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }
}

