/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccNormSkuDelServiceAbilityService;
import com.tydic.commodity.zone.ability.bo.UccBatchSpuBO;
import com.tydic.commodity.zone.ability.bo.UccNormSkuDelServiceAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccNormSkuDelServiceAbilityRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccNormSkuDelServiceAbilityService"})
public class UccNormSkuDelServiceAbilityServiceImpl
implements UccNormSkuDelServiceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccNormSkuDelServiceAbilityServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    @PostMapping(value={"deleteSpu"})
    public UccNormSkuDelServiceAbilityRspBO deleteSpu(@RequestBody UccNormSkuDelServiceAbilityReqBO reqBO) {
        UccNormSkuDelServiceAbilityRspBO rspBO = new UccNormSkuDelServiceAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSpuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List reqCmmds = reqBO.getBatchSpuList().stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
        List uccSkuPos = this.uccSkuMapper.qrySkuByCommoditys(reqCmmds, ((UccBatchSpuBO)reqBO.getBatchSpuList().get(0)).getSupplierShopId());
        if (CollectionUtils.isEmpty((Collection)uccSkuPos) || uccSkuPos.size() != reqCmmds.size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5220\u9664\u5546\u54c1\u4e0d\u5b58\u5728");
            return rspBO;
        }
        log.info("\u67e5\u8be2\u5546\u54c1\u6570\u636e:" + JSONObject.toJSONString((Object)uccSkuPos));
        for (UccSkuPo each : uccSkuPos) {
            if (each.getSkuStatus() == 0 || each.getSkuStatus() == 4) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(each.getCommodityId() + "\u5546\u54c1\u4e0d\u662f\u8349\u7a3f/\u9a73\u56de\u72b6\u6001");
            return rspBO;
        }
        this.uccSkuMapper.batchDeleteSku(reqCmmds);
        this.uccCommodityMapper.batchDeleteCommodity(reqCmmds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        for (UccBatchSpuBO uccBatchSpuBO : reqBO.getBatchSpuList()) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(reqCmmds);
            syncSceneCommodityToEsReqBO.setSupplierId(uccBatchSpuBO.getSupplierShopId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_DELETE_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        return rspBO;
    }
}

