/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.SkuInfoImageBo;
import com.tydic.commodity.base.bo.SkuInfoPriceBo;
import com.tydic.commodity.base.bo.SkuInfoSpecBo;
import com.tydic.commodity.base.bo.SkuPutCirBo;
import com.tydic.commodity.base.bo.UccLadderPriceInfo;
import com.tydic.commodity.base.bo.UccSkuExpandBo;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuDetailEditMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuEditMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecEditMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityPropGrpPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuDetailEditPO;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuEditPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.po.UccSpuSpecPo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.api.UccZoneSkuEditdetailsQryAbilityService;
import com.tydic.commodity.zone.ability.bo.UccSkuEditDetailInfoBO;
import com.tydic.commodity.zone.ability.bo.UccSkuEditdetailsQryAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccSkuEditdetailsQryAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccSkuSpecBO;
import com.tydic.commodity.zone.atom.api.UccZoneDictionaryAtomService;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccZoneSkuEditdetailsQryAbilityService"})
public class UccZoneSkuEditdetailsQryAbilityServiceImpl
implements UccZoneSkuEditdetailsQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccZoneSkuEditdetailsQryAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuEditMapper uccSkuEditMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuDetailEditMapper uccSkuDetailEditMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private UccZoneDictionaryAtomService uccZoneDictionaryAtomService;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuSpecEditMapper uccSkuSpecEditMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;

    @PostMapping(value={"getSkuEditDetailQry"})
    public UccSkuEditdetailsQryAbilityRspBO getSkuEditDetailQry(@RequestBody UccSkuEditdetailsQryAbilityReqBO reqBO) {
        UccSkuEditDetailInfoBO skuEditInfo = new UccSkuEditDetailInfoBO();
        this.buildSkuInfo(skuEditInfo, reqBO);
        this.buildSkuSpec(skuEditInfo, reqBO);
        this.buildSkuPic(skuEditInfo, reqBO);
        this.buildSkuExpand(skuEditInfo, reqBO);
        this.buildSkuPrice(skuEditInfo, reqBO);
        this.buildSkuPutCrir(skuEditInfo, reqBO);
        UccSkuEditdetailsQryAbilityRspBO rspBO = new UccSkuEditdetailsQryAbilityRspBO();
        rspBO.setSkuItem(skuEditInfo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void buildSkuPutCrir(UccSkuEditDetailInfoBO skuEditInfo, UccSkuEditdetailsQryAbilityReqBO reqBO) {
        UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
        uccSkuPutCirPo.setSkuId(reqBO.getSkuId());
        uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPutCirPo.setState(Integer.valueOf(1));
        List uccSkuPutCirPoList = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
        ArrayList<SkuPutCirBo> skuPutCir = new ArrayList<SkuPutCirBo>();
        if (uccSkuPutCirPoList != null && !uccSkuPutCirPoList.isEmpty()) {
            for (UccSkuPutCirPo each : uccSkuPutCirPoList) {
                SkuPutCirBo skuPutCirBo = new SkuPutCirBo();
                BeanUtils.copyProperties((Object)each, (Object)skuPutCirBo);
                skuPutCir.add(skuPutCirBo);
            }
        }
        skuEditInfo.setSkuPutCir(skuPutCir);
        skuEditInfo.setOldSkuPutCir(skuPutCir);
    }

    private void buildSkuPrice(UccSkuEditDetailInfoBO skuEditInfo, UccSkuEditdetailsQryAbilityReqBO reqBO) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(reqBO.getSkuId());
        uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
        SkuInfoPriceBo skuInfoPriceBo = new SkuInfoPriceBo();
        UccSkuPricePo result = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (result != null) {
            BeanUtils.copyProperties((Object)result, (Object)skuInfoPriceBo);
            if (result.getMarketPrice() != null) {
                skuInfoPriceBo.setMarketPrice(MoneyUtils.haoToYuan((Long)result.getMarketPrice()));
            }
            if (result.getAgreementPrice() != null) {
                skuInfoPriceBo.setAgreementPrice(MoneyUtils.haoToYuan((Long)result.getAgreementPrice()));
            }
            if (result.getSalePrice() != null) {
                skuInfoPriceBo.setSalePrice(MoneyUtils.haoToYuan((Long)result.getSalePrice()));
            }
            if (result.getMemberPrice1() != null) {
                skuInfoPriceBo.setMemberPrice1(MoneyUtils.haoToYuan((Long)result.getMemberPrice1()));
            }
            if (result.getMemberPrice2() != null) {
                skuInfoPriceBo.setMemberPrice2(MoneyUtils.haoToYuan((Long)result.getMemberPrice2()));
            }
            if (result.getMemberPrice3() != null) {
                skuInfoPriceBo.setMemberPrice3(MoneyUtils.haoToYuan((Long)result.getMemberPrice3()));
            }
            if (result.getMemberPrice4() != null) {
                skuInfoPriceBo.setMemberPrice4(MoneyUtils.haoToYuan((Long)result.getMemberPrice4()));
            }
            if (result.getMemberPrice5() != null) {
                skuInfoPriceBo.setMemberPrice5(MoneyUtils.haoToYuan((Long)result.getMemberPrice5()));
            }
            if (result.getSwitchOn() != null && result.getSwitchOn() == 1) {
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                uccLadderPricePO.setSkuPriceId(result.getSkuPriceId());
                List uccLadderPricePOList = this.uccLadderPriceMapper.selectByExample(uccLadderPricePO);
                ArrayList<UccLadderPriceInfo> uccLadderPriceInfoList = new ArrayList<UccLadderPriceInfo>();
                if (uccLadderPricePOList != null && !uccLadderPricePOList.isEmpty()) {
                    for (UccLadderPricePO each : uccLadderPricePOList) {
                        UccLadderPriceInfo uccLadderPriceInfo = new UccLadderPriceInfo();
                        BeanUtils.copyProperties((Object)each, (Object)uccLadderPriceInfo);
                        if (each.getStart() != null) {
                            uccLadderPriceInfo.setStart(MoneyUtils.haoToYuan((Long)each.getStart()));
                        }
                        if (each.getStop() != null) {
                            uccLadderPriceInfo.setStop(MoneyUtils.haoToYuan((Long)each.getStop()));
                        }
                        if (each.getPrice() != null) {
                            uccLadderPriceInfo.setPrice(MoneyUtils.haoToYuan((Long)each.getPrice()));
                        }
                        uccLadderPriceInfoList.add(uccLadderPriceInfo);
                    }
                    skuInfoPriceBo.setLadderPriceInfo(uccLadderPriceInfoList);
                }
            }
        }
        skuEditInfo.setSkuInfoPrice(skuInfoPriceBo);
        skuEditInfo.setOldSkuInfoPrice(skuInfoPriceBo);
    }

    private void buildSkuExpand(UccSkuEditDetailInfoBO skuEditInfo, UccSkuEditdetailsQryAbilityReqBO reqBO) {
        UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
        uccSkuExpandPo.setSkuId(reqBO.getSkuId());
        uccSkuExpandPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuExpandPoList = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
        if (uccSkuExpandPoList != null && !uccSkuExpandPoList.isEmpty()) {
            UccSkuExpandBo uccSkuExpandBo = new UccSkuExpandBo();
            BeanUtils.copyProperties(uccSkuExpandPoList.get(0), (Object)uccSkuExpandBo);
            skuEditInfo.setSkuExpand(uccSkuExpandBo);
            skuEditInfo.setOldSkuExpand(uccSkuExpandBo);
        }
    }

    private void buildSkuPic(UccSkuEditDetailInfoBO skuEditInfo, UccSkuEditdetailsQryAbilityReqBO reqBO) {
        UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
        uccSkuPicPo.setSkuId(reqBO.getSkuId());
        uccSkuPicPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuPicPos = this.uccSkuPicMapper.qeurySkuPic(uccSkuPicPo);
        ArrayList<SkuInfoImageBo> skuImags = new ArrayList<SkuInfoImageBo>();
        if (CollectionUtils.isNotEmpty((Collection)uccSkuPicPos)) {
            for (UccSkuPicPo uccSkuPicPo1 : uccSkuPicPos) {
                SkuInfoImageBo skuInfoImageBo = new SkuInfoImageBo();
                BeanUtils.copyProperties((Object)uccSkuPicPo1, (Object)skuInfoImageBo);
                skuImags.add(skuInfoImageBo);
            }
        }
        skuEditInfo.setSkuImages(skuImags);
        skuEditInfo.setOldSkuImages(skuImags);
    }

    private void buildSkuSpec(UccSkuEditDetailInfoBO skuEditInfo, UccSkuEditdetailsQryAbilityReqBO reqBO) {
        UccSkuSpecPo uccSkuSpecPo = new UccSkuSpecPo();
        uccSkuSpecPo.setSkuId(reqBO.getSkuId());
        uccSkuSpecPo.setSupplierShopId(reqBO.getSupplierShopId());
        List uccSkuSpecPos = this.uccSkuSpecMapper.querySpecInfos(uccSkuSpecPo);
        ArrayList<UccSkuSpecPo> skuSpecList = new ArrayList<UccSkuSpecPo>();
        UccSpuSpecPo uccSpuSpecPo = new UccSpuSpecPo();
        uccSpuSpecPo.setCommodityId(skuEditInfo.getCommodityId());
        uccSpuSpecPo.setSupplierShopId(skuEditInfo.getSupplierShopId());
        List uccSpuSpecPos = this.uccSpuSpecMapper.querySpec(uccSpuSpecPo);
        if (CollectionUtils.isNotEmpty((Collection)uccSpuSpecPos)) {
            for (UccSpuSpecPo spuSpecPo : uccSpuSpecPos) {
                UccSkuSpecPo temp = new UccSkuSpecPo();
                BeanUtils.copyProperties((Object)spuSpecPo, (Object)temp);
                skuSpecList.add(temp);
            }
        }
        uccSkuSpecPos.addAll(skuSpecList);
        if (!uccSkuSpecPos.isEmpty()) {
            ArrayList<UccSkuSpecBO> skuSpec = new ArrayList<UccSkuSpecBO>();
            HashSet<String> commodityPropGrpNameSet = new HashSet<String>();
            for (UccSkuSpecPo each : uccSkuSpecPos) {
                commodityPropGrpNameSet.add(each.getCommodityPropGrpName());
            }
            for (String commodityPropGrpName : commodityPropGrpNameSet) {
                ArrayList<SkuInfoSpecBo> skuInfoSpecBoList = new ArrayList<SkuInfoSpecBo>();
                Long commodityPropGrpId = null;
                for (UccSkuSpecPo each : uccSkuSpecPos) {
                    if (!each.getCommodityPropGrpName().equals(commodityPropGrpName)) continue;
                    SkuInfoSpecBo skuInfoSpecBo = new SkuInfoSpecBo();
                    BeanUtils.copyProperties((Object)each, (Object)skuInfoSpecBo);
                    skuInfoSpecBoList.add(skuInfoSpecBo);
                    if (commodityPropGrpId != null) continue;
                    commodityPropGrpId = each.getCommodityPropGrpId();
                }
                UccSkuSpecBO skuSpecBO = new UccSkuSpecBO();
                skuSpecBO.setCommodityPropGrpId(commodityPropGrpId);
                skuSpecBO.setCommodityPropGrpName(commodityPropGrpName);
                skuSpecBO.setSkuSpecs(skuInfoSpecBoList);
                skuSpec.add(skuSpecBO);
            }
            skuEditInfo.setSkuSpec(skuSpec);
            skuEditInfo.setOldSkuSpec(skuSpec);
        }
        if (skuEditInfo.getSkuSpec() != null) {
            skuEditInfo.setSkuSpecNoGroup(this.getListNoGroup(skuEditInfo.getSkuSpec()));
        }
        if (skuEditInfo.getOldSkuSpec() != null) {
            skuEditInfo.setOldSkuSpecNoGroup(this.getListNoGroup(skuEditInfo.getOldSkuSpec()));
        }
    }

    private List<SkuInfoSpecBo> getListNoGroup(List<UccSkuSpecBO> skuSpec) {
        ArrayList skuSpecNoGroup = new ArrayList();
        for (UccSkuSpecBO each : skuSpec) {
            skuSpecNoGroup.addAll(each.getSkuSpecs());
        }
        ArrayList<SkuInfoSpecBo> resultList = new ArrayList<SkuInfoSpecBo>();
        Map<Long, List<SkuInfoSpecBo>> collect1 = skuSpecNoGroup.stream().collect(Collectors.groupingBy(SkuInfoSpecBo::getCommodityPropGrpId));
        for (List<SkuInfoSpecBo> each : collect1.values()) {
            UccCommodityPropGrpPo uccCommodityPropGrpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId(each.get(0).getCommodityPropGrpId());
            Integer commodityPropGrpType = null;
            if (uccCommodityPropGrpPo != null) {
                commodityPropGrpType = uccCommodityPropGrpPo.getCommodityPropGrpType();
            }
            Map<Long, List<SkuInfoSpecBo>> collect2 = each.stream().collect(Collectors.groupingBy(SkuInfoSpecBo::getCommodityPropDefId));
            for (List<SkuInfoSpecBo> each2 : collect2.values()) {
                SkuInfoSpecBo skuInfoSpecBo = new SkuInfoSpecBo();
                String strEach2 = JSONObject.toJSONString((Object)each2.get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                skuInfoSpecBo = (SkuInfoSpecBo)JSONObject.parseObject((String)strEach2, SkuInfoSpecBo.class);
                skuInfoSpecBo.setCommodityPropGrpType(commodityPropGrpType);
                skuInfoSpecBo.setPropValue("");
                skuInfoSpecBo.setPropValueListId(null);
                for (SkuInfoSpecBo skuInfoSpecBo2 : each2) {
                    String i = ",";
                    if (StringUtils.isEmpty((Object)skuInfoSpecBo.getPropValue())) {
                        i = "";
                    }
                    skuInfoSpecBo.setPropValue(skuInfoSpecBo.getPropValue() + i + skuInfoSpecBo2.getPropValue());
                }
                resultList.add(skuInfoSpecBo);
            }
        }
        resultList.sort(Comparator.comparingInt(SkuInfoSpecBo::getCommodityPropGrpType));
        return resultList;
    }

    private void buildSkuInfo(UccSkuEditDetailInfoBO skuEditInfo, UccSkuEditdetailsQryAbilityReqBO reqBO) {
        block16: {
            Map<String, String> onShelveWayMap = this.uccZoneDictionaryAtomService.queryBypCodeBackMap("SKU_ON_SHELVE_WAY");
            Map<String, String> skuStatusMap = this.uccZoneDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isNotEmpty((Collection)uccSkuPoList)) {
                UccEMdmMaterialPO uccEMdmMaterialPo;
                UccCommodityTypePo uccCommodityTypePo;
                UccSkuPo skuPO = (UccSkuPo)uccSkuPoList.get(0);
                skuEditInfo.setSkuId(skuPO.getSkuId());
                skuEditInfo.setCommodityId(skuPO.getCommodityId());
                skuEditInfo.setSkuCode(skuPO.getSkuCode());
                skuEditInfo.setSkuName(skuPO.getSkuName());
                skuEditInfo.setCommodityTypeId(skuPO.getCommodityTypeId());
                if (skuPO.getCommodityTypeId() != null && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(skuPO.getCommodityTypeId())) != null) {
                    skuEditInfo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                }
                skuEditInfo.setSupplierShopId(skuPO.getSupplierShopId());
                skuEditInfo.setShopName(skuPO.getShopName());
                skuEditInfo.setBrandId(skuPO.getBrandId());
                skuEditInfo.setBrandName(skuPO.getBrandName());
                skuEditInfo.setPreDeliverDay(Integer.valueOf(Integer.parseInt(skuPO.getPreDeliverDay())));
                skuEditInfo.setUpcCode(skuPO.getUpcCode());
                UccCommodityPo uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(skuPO.getCommodityId(), skuPO.getSupplierShopId());
                if (uccCommodityPo != null) {
                    skuEditInfo.setRate(uccCommodityPo.getRate());
                    skuEditInfo.setOrgId(Long.valueOf(Long.parseLong(uccCommodityPo.getOrgId())));
                    skuEditInfo.setOrgName(uccCommodityPo.getOrgName());
                }
                skuEditInfo.setMeasureId(skuPO.getMeasureId());
                skuEditInfo.setMeasureName(skuPO.getMeasureName());
                skuEditInfo.setMoq(skuPO.getMoq());
                skuEditInfo.setMfgSku(skuPO.getMfgsku());
                skuEditInfo.setMaterialId(Long.valueOf(Long.parseLong(skuPO.getMaterialId())));
                if (skuPO.getMaterialId() != null && (uccEMdmMaterialPo = this.uccEMdmMaterialMapper.queryById(Long.valueOf(Long.parseLong(skuPO.getMaterialId())))) != null) {
                    skuEditInfo.setLongDesc(uccEMdmMaterialPo.getLongDesc());
                    skuEditInfo.setMaterialCode(uccEMdmMaterialPo.getMaterialCode());
                    skuEditInfo.setMateriaName(uccEMdmMaterialPo.getMaterialName());
                }
                skuEditInfo.setOnShelveTime(skuPO.getOnShelveTime());
                skuEditInfo.setOnShelveWay(skuPO.getOnShelveWay());
                if (skuEditInfo.getOnShelveWay() != null && onShelveWayMap != null && onShelveWayMap.containsKey(skuEditInfo.getOnShelveWay().toString())) {
                    skuEditInfo.setOnShelveWayDec(onShelveWayMap.get(skuEditInfo.getOnShelveWay().toString()));
                }
                skuEditInfo.setPreOnShelveDay(skuPO.getPreOnShelveDay());
                skuEditInfo.setWeight(skuPO.getWeight());
                skuEditInfo.setModel(skuPO.getModel());
                skuEditInfo.setSpec(skuPO.getSpec());
                skuEditInfo.setSalesUnitId(skuPO.getSalesUnitId());
                skuEditInfo.setSalesUnitName(skuPO.getSalesUnitName());
                skuEditInfo.setSalesUnitRate(skuPO.getSalesUnitRate().toString());
                skuEditInfo.setPackageSpec(skuPO.getPackageSpec());
                skuEditInfo.setSettlementUnit(skuPO.getSettlementUnit());
                skuEditInfo.setIsFactoryShip(skuPO.getIsFactoryShip());
                skuEditInfo.setCreateOperId(skuPO.getCreateOperId());
                skuEditInfo.setCreateOperName(skuPO.getCreateOperName());
                skuEditInfo.setCreateTime(skuPO.getCreateTime());
                skuEditInfo.setUpdateOperName(skuPO.getUpdateOperName());
                skuEditInfo.setUpdateOperId(skuPO.getUpdateOperId());
                skuEditInfo.setUpdateTime(skuPO.getUpdateTime());
                skuEditInfo.setRemark(skuPO.getRemark());
                skuEditInfo.setTexture(skuPO.getTexture());
                skuEditInfo.setFigure(skuPO.getFigure());
                skuEditInfo.setManufacturer(skuPO.getManufacturer());
            }
            UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
            uccSkuDetailPO.setSkuId(reqBO.getSkuId());
            uccSkuDetailPO.setSupplierShopId(reqBO.getSupplierShopId());
            List uccSkuDetailPOS = this.uccSkuDetailMapper.qerySku(uccSkuDetailPO);
            if (CollectionUtils.isNotEmpty((Collection)uccSkuDetailPOS) && ((UccSkuDetailPO)uccSkuDetailPOS.get(0)).getSkuId().equals(reqBO.getSkuId())) {
                UccSkuDetailPO skuDetailPO = (UccSkuDetailPO)uccSkuDetailPOS.get(0);
                skuEditInfo.setSkuPcDetailUrl(skuDetailPO.getSkuPcDetailUrl());
                skuEditInfo.setSkuPcDetailChar(skuDetailPO.getSkuPcDetailChar());
                skuEditInfo.setSkuPhoneDetailUrl(skuDetailPO.getSkuPhoneDetailUrl());
                skuEditInfo.setSkuPhoneDetailChar(skuDetailPO.getSkuPhoneDetailChar());
            }
            UccSkuEditPO uccSkuEditPO = new UccSkuEditPO();
            uccSkuEditPO.setSkuId(reqBO.getSkuId());
            uccSkuEditPO.setSupplierShopId(reqBO.getSupplierShopId());
            UccSkuEditPO editSkuPO = this.uccSkuEditMapper.getModelBy(uccSkuEditPO);
            if (!Objects.isNull(editSkuPO)) {
                UccEMdmMaterialPO uccEMdmMaterialPo;
                UccCommodityTypePo uccCommodityTypePo;
                skuEditInfo.setOldSkuCode(editSkuPO.getSkuCode());
                skuEditInfo.setOldSkuName(editSkuPO.getSkuName());
                skuEditInfo.setOldCommodityTypeId(editSkuPO.getCommodityTypeId());
                if (editSkuPO.getCommodityTypeId() != null && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(editSkuPO.getCommodityTypeId())) != null) {
                    skuEditInfo.setOldCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                }
                skuEditInfo.setOldBrandId(editSkuPO.getBrandId());
                skuEditInfo.setOldBrandName(editSkuPO.getBrandName());
                skuEditInfo.setOldPreDeliverDay(editSkuPO.getPreDeliverDay());
                skuEditInfo.setOldUpcCode(editSkuPO.getUpcCode());
                UccCommodityPo uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(editSkuPO.getCommodityId(), editSkuPO.getSupplierShopId());
                if (uccCommodityPo != null) {
                    skuEditInfo.setOldRate(uccCommodityPo.getRate());
                }
                skuEditInfo.setOldMeasureId(editSkuPO.getMeasureId());
                skuEditInfo.setMeasureName(editSkuPO.getMeasureName());
                skuEditInfo.setOldMoq(editSkuPO.getMoq());
                skuEditInfo.setOldMfgsku(editSkuPO.getMfgsku());
                skuEditInfo.setOldMaterialId(Long.valueOf(Long.parseLong(editSkuPO.getMaterialId())));
                if (editSkuPO.getMaterialId() != null && (uccEMdmMaterialPo = this.uccEMdmMaterialMapper.queryById(Long.valueOf(Long.parseLong(editSkuPO.getMaterialId())))) != null) {
                    skuEditInfo.setOldLongDesc(uccEMdmMaterialPo.getLongDesc());
                    skuEditInfo.setOldMaterialCode(uccEMdmMaterialPo.getMaterialCode());
                    skuEditInfo.setOldMateriaName(uccEMdmMaterialPo.getMaterialName());
                }
                skuEditInfo.setOldOnShelveTime(editSkuPO.getOnShelveTime());
                skuEditInfo.setOldOnShelveWay(editSkuPO.getOnShelveWay());
                if (skuEditInfo.getOldOnShelveWay() != null && onShelveWayMap != null && onShelveWayMap.containsKey(skuEditInfo.getOldOnShelveWay().toString())) {
                    skuEditInfo.setOldOnShelveWayDec(onShelveWayMap.get(skuEditInfo.getOnShelveWay().toString()));
                }
                skuEditInfo.setOldPreOnShelveDay(editSkuPO.getPreOnShelveDay());
                skuEditInfo.setOldWeight(editSkuPO.getWeight());
                skuEditInfo.setOldModel(editSkuPO.getModel());
                skuEditInfo.setOldSpec(editSkuPO.getSpec());
                skuEditInfo.setOldSalesUnitId(editSkuPO.getSalesUnitId());
                skuEditInfo.setOldSalesUnitName(editSkuPO.getSalesUnitName());
                skuEditInfo.setOldSalesUnitRate(editSkuPO.getSalesUnitRate().toString());
                skuEditInfo.setOldPackageSpec(editSkuPO.getPackageSpec());
                skuEditInfo.setOldSettlementUnit(editSkuPO.getSettlementUnit());
                skuEditInfo.setOldIsFactoryShip(editSkuPO.getIsFactoryShip());
                skuEditInfo.setOldTexture(editSkuPO.getTexture());
                skuEditInfo.setOldFigure(editSkuPO.getFigure());
                skuEditInfo.setOldManufacturer(editSkuPO.getManufacturer());
            }
            UccSkuDetailEditPO uccSkuDetailEditPO = new UccSkuDetailEditPO();
            uccSkuDetailEditPO.setSkuId(reqBO.getSkuId());
            uccSkuDetailEditPO.setSupplierShopId(reqBO.getSupplierShopId());
            List uccSkuDetailEditPOS = this.uccSkuDetailEditMapper.qerySku(uccSkuDetailEditPO);
            if (CollectionUtils.isNotEmpty((Collection)uccSkuDetailEditPOS) && ((UccSkuDetailEditPO)uccSkuDetailEditPOS.get(0)).getSkuId().equals(reqBO.getSkuId())) {
                UccSkuDetailEditPO skuDetailEditPO = (UccSkuDetailEditPO)uccSkuDetailEditPOS.get(0);
                skuEditInfo.setOldSkuPcDetailUrl(skuDetailEditPO.getSkuPcDetailUrl());
                skuEditInfo.setOldSkuPcDetailChar(skuDetailEditPO.getSkuPcDetailChar());
                skuEditInfo.setOldSkuPhoneDetailUrl(skuDetailEditPO.getSkuPhoneDetailUrl());
                skuEditInfo.setOldSkuPhoneDetailChar(skuDetailEditPO.getSkuPhoneDetailChar());
            }
            try {
                SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
                smcsdkQryStockNumReqBO.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{reqBO.getSkuId()}));
                SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
                log.info("\u7b80\u7248\u5e93\u5b58\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
                if ("0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
                    Map getMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
                    if (getMap != null && getMap.containsKey(reqBO.getSkuId())) {
                        skuEditInfo.setTotalNum(MoneyUtils.haoToYuan((Long)((Long)getMap.get(reqBO.getSkuId()))));
                        skuEditInfo.setOldTotalNum(MoneyUtils.haoToYuan((Long)((Long)getMap.get(reqBO.getSkuId()))));
                    }
                    break block16;
                }
                log.error("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
                throw new BusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_QRY_FAIL.code(), "\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
    }
}

