/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.zone.atom.api.UccZoneDictionaryAtomService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UccZoneDictionaryAtomServiceImpl
implements UccZoneDictionaryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccZoneDictionaryAtomServiceImpl.class);
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public List<DicDictionaryPo> queryBypCodeBackPo(String pCode) {
        return this.uccDicDictionaryMapper.selectByPCode(pCode);
    }

    @Override
    public Map<String, String> queryBypCodeBackMap(String pCode) {
        List listPo = this.uccDicDictionaryMapper.selectByPCode(pCode);
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DicDictionaryPo po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }

    @Override
    public DicDictionaryPo queryByCodeAndPcode(String code, String pCode) {
        if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)pCode)) {
            throw new BusinessException("PARAM_NOT_BE_NULL", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DicDictionaryPo po = null;
        Object title = this.cacheClient.get(pCode + code);
        if (title != null) {
            try {
                po = (DicDictionaryPo)title;
                return po;
            }
            catch (Exception e) {
                log.error("\u5b57\u5178\u8f6c\u6362\u5f02\u5e38\uff1a{UccDictionaryAtomService.queryByCodeAndPcode}" + e.getMessage());
            }
        }
        po = this.uccDicDictionaryMapper.selectdictionaryByCodeAndCode(code, pCode);
        try {
            this.cacheClient.set(pCode + code, (Object)po);
        }
        catch (Exception e) {
            log.error("\u5b57\u5178\u7f13\u5b58\u5931\u8d25\uff1a{UccDictionaryAtomService.queryByCodeAndPcode}" + e.getMessage());
        }
        return po;
    }
}

