/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.LadderPriceBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.dao.UccOrgSkuLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.po.UccOrgSkuLadderPricePO;
import com.tydic.commodity.po.UccOrgSkuPO;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.zone.ability.bo.UccAgrAutoSkuAbilityBO;
import com.tydic.commodity.zone.busi.api.UccAgrAutoSkuBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrAutoSkuBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrAutoSkuBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrAutoSkuBusiServiceImpl
implements UccAgrAutoSkuBusiService {
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;
    @Autowired
    private UccOrgSkuLadderPriceMapper uccOrgSkuLadderPriceMapper;

    @Override
    public UccAgrAutoSkuBusiRspBO dealUccAgrAutoSku(UccAgrAutoSkuBusiReqBO reqBO) {
        if (UccConstants.AgrAutoSkuOperType.INSERT.equals(reqBO.getType())) {
            this.doInsert(reqBO);
        } else if (UccConstants.AgrAutoSkuOperType.DELETE.equals(reqBO.getType())) {
            this.doDelete(reqBO);
        } else if (UccConstants.AgrAutoSkuOperType.UPDATE.equals(reqBO.getType())) {
            this.doUpdate(reqBO);
        }
        UccAgrAutoSkuBusiRspBO rspBO = new UccAgrAutoSkuBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void doUpdate(UccAgrAutoSkuBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getAgreementInfo())) {
            for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
                UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
                BeanUtils.copyProperties((Object)uccAgrAutoSkuAbilityBO, (Object)uccOrgSkuPO);
                this.uccOrgSkuMapper.updateBy(uccOrgSkuPO, uccOrgSkuPO);
                if (!UccConstants.SwitchOn.ON.equals(uccAgrAutoSkuAbilityBO.getSwitchOn())) continue;
                for (LadderPriceBO ladderPriceBO : uccAgrAutoSkuAbilityBO.getLadderPrice()) {
                    UccOrgSkuLadderPricePO uccOrgSkuLadderPricePO = new UccOrgSkuLadderPricePO();
                    BeanUtils.copyProperties((Object)ladderPriceBO, (Object)uccOrgSkuLadderPricePO);
                    this.uccOrgSkuLadderPriceMapper.updateBy(uccOrgSkuLadderPricePO, uccOrgSkuLadderPricePO);
                }
            }
        }
    }

    private void doDelete(UccAgrAutoSkuBusiReqBO reqBO) {
        UccOrgSkuPO uccOrgSkuPO = new UccOrgSkuPO();
        uccOrgSkuPO.setAgreementId(reqBO.getAgreementId());
        List uccOrgSkuPOS = this.uccOrgSkuMapper.getList(uccOrgSkuPO);
        this.uccOrgSkuMapper.deleteBy(uccOrgSkuPO);
        if (!CollectionUtils.isEmpty((Collection)uccOrgSkuPOS)) {
            List virtualSkuIds = uccOrgSkuPOS.stream().map(UccOrgSkuPO::getVirtualSkuId).collect(Collectors.toList());
            this.uccOrgSkuLadderPriceMapper.deleteByVirtualSkuIds(virtualSkuIds);
        }
        UccOrgSkuWhiteRestrictionPo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionPo();
        uccOrgSkuWhiteRestrictionPo.setAgreementId(reqBO.getAgreementId());
        this.uccOrgSkuWhiteRestrictionMapper.deleteBy(uccOrgSkuWhiteRestrictionPo);
    }

    private void doInsert(UccAgrAutoSkuBusiReqBO reqBO) {
        List<UccAgrAutoSkuAbilityBO> agreementInfo = reqBO.getAgreementInfo();
        List uccOrgSkuPOS = JSON.parseArray((String)JSON.toJSONString(agreementInfo), UccOrgSkuPO.class);
        for (Object uccOrgSkuPO : uccOrgSkuPOS) {
            uccOrgSkuPO.setAgreementId(reqBO.getAgreementId());
            uccOrgSkuPO.setVirtualSkuId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        this.uccOrgSkuMapper.insertBatch(uccOrgSkuPOS);
        List list = new ArrayList();
        if (!CollectionUtils.isEmpty(reqBO.getRegion())) {
            list = JSON.parseArray((String)JSON.toJSONString(reqBO.getRegion()), UccOrgSkuWhiteRestrictionPo.class);
            for (UccOrgSkuWhiteRestrictionPo uccOrgSkuWhiteRestrictionPo : list) {
                uccOrgSkuWhiteRestrictionPo.setAgreementId(reqBO.getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.uccOrgSkuWhiteRestrictionMapper.insertBatch(list);
        }
        Map<Long, UccOrgSkuPO> uccOrgSkuPOMap = uccOrgSkuPOS.stream().collect(Collectors.toMap(UccOrgSkuPO::getSkuId, entity -> entity));
        ArrayList<UccOrgSkuLadderPricePO> uccOrgSkuLadderPricePOS = new ArrayList<UccOrgSkuLadderPricePO>();
        for (UccAgrAutoSkuAbilityBO uccAgrAutoSkuAbilityBO : reqBO.getAgreementInfo()) {
            if (!UccConstants.SwitchOn.ON.equals(uccAgrAutoSkuAbilityBO.getSwitchOn())) continue;
            List ladderPrice = uccAgrAutoSkuAbilityBO.getLadderPrice();
            for (LadderPriceBO ladderPriceBO : ladderPrice) {
                UccOrgSkuLadderPricePO uccOrgSkuLadderPricePO = new UccOrgSkuLadderPricePO();
                uccOrgSkuLadderPricePO.setDiscount(ladderPriceBO.getDiscount());
                uccOrgSkuLadderPricePO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccOrgSkuLadderPricePO.setPrice(Long.valueOf(ladderPriceBO.getPrice().longValue()));
                uccOrgSkuLadderPricePO.setStart(ladderPriceBO.getStart());
                uccOrgSkuLadderPricePO.setStop(ladderPriceBO.getStop());
                uccOrgSkuLadderPricePO.setVirtualSkuId(uccOrgSkuPOMap.get(uccAgrAutoSkuAbilityBO.getSkuId()).getVirtualSkuId());
                uccOrgSkuLadderPricePOS.add(uccOrgSkuLadderPricePO);
            }
        }
        if (!CollectionUtils.isEmpty(uccOrgSkuLadderPricePOS)) {
            this.uccOrgSkuLadderPriceMapper.insertBatch(uccOrgSkuLadderPricePOS);
        }
    }
}

