/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccLadderPriceInfo;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccNewSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuSpecMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.SupplierShopPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.po.UccSkuSpecPo;
import com.tydic.commodity.po.UccVendorPo;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.zone.ability.bo.UccNormSpuCreateAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccNormSpuCreateAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccSpuCreateBusiService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSpuCreateBusiServiceImpl
implements UccSpuCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSpuCreateBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccSkuSpecMapper uccSkuSpecMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Resource(name="uccSkuIdSequence")
    private OrderSequence orderSequence;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="uccCommodityIdSequence")
    private OrderSequence uccCommodityIdSequence;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccNewSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Value(value="${ARG_EDIT_PROCESS_DEF_ID}")
    private String process;

    @Override
    public UccNormSpuCreateAbilityRspBO dealCreateNormSpu(UccNormSpuCreateAbilityReqBO reqBO) {
        UccNormSpuCreateAbilityRspBO rspBO = new UccNormSpuCreateAbilityRspBO();
        if (reqBO.getNormSpuInfo().getVendorId() != null) {
            UccVendorPo uccVendorPo = new UccVendorPo();
            uccVendorPo.setVendorId(reqBO.getNormSpuInfo().getVendorId());
            List vendorPoList = this.uccVendorMapper.queryVerdor(uccVendorPo);
            if (CollectionUtils.isEmpty((Collection)vendorPoList)) {
                uccVendorPo = new UccVendorPo();
                uccVendorPo.setVendorId(reqBO.getNormSpuInfo().getVendorId());
                uccVendorPo.setId(reqBO.getNormSpuInfo().getVendorId());
                uccVendorPo.setVendorName(reqBO.getNormSpuInfo().getVendorName());
                uccVendorPo.setVendorCode(reqBO.getNormSpuInfo().getVendorId().toString());
                this.uccVendorMapper.insert(uccVendorPo);
            }
        }
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        Long commodityId = null;
        try {
            commodityId = this.uccCommodityIdSequence.nextId();
            uccCommodityPo.setCommodityCode(commodityId.toString());
            uccCommodityPo.setCommodityId(commodityId);
        }
        catch (SQLException e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
        }
        SupplierShopPo supplierShopPo = new SupplierShopPo();
        List supplierShopPos = this.supplierShopMapper.queryAllSupplierShopDetails(supplierShopPo);
        if (CollectionUtils.isEmpty((Collection)supplierShopPos)) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u67e5\u8be2\u5e97\u94fa\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long supplierShopId = ((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId();
        uccCommodityPo.setSupplierShopId(supplierShopId);
        uccCommodityPo.setCommodityTypeId(reqBO.getNormSpuInfo().getCommodityTypeId());
        uccCommodityPo.setCommodityStatus(Integer.valueOf(0));
        this.uccCommodityMapper.addcommodity(uccCommodityPo);
        String json = JSONObject.toJSONString((Object)reqBO.getNormSpuInfo(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        UccSkuPo uccSkuPo = (UccSkuPo)JSON.parseObject((String)json, UccSkuPo.class);
        if (reqBO.getOperType() == 0) {
            uccSkuPo.setSkuStatus(Integer.valueOf(0));
        } else if (reqBO.getOperType() == 1) {
            uccSkuPo.setSkuStatus(Integer.valueOf(1));
        }
        uccSkuPo.setVendorId(reqBO.getNormSpuInfo().getVendorId());
        uccSkuPo.setVendorName(reqBO.getNormSpuInfo().getVendorName());
        uccSkuPo.setSkuSource(Integer.valueOf(3));
        uccSkuPo.setCommodityId(commodityId);
        uccSkuPo.setSupplierShopId(supplierShopId);
        uccSkuPo.setSkuPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getNormSpuInfo().getSkuInfoPrice().getSalePrice())));
        try {
            uccSkuPo.setSkuId(Long.valueOf(this.orderSequence.nextId()));
        }
        catch (SQLException e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u5e8f\u5217\u751f\u6210\u5931\u8d25\uff01");
        }
        uccSkuPo.setSkuCode(uccSkuPo.getSkuId().toString());
        try {
            this.uccSkuMapper.addsku(uccSkuPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getNormSpuInfo().getSkuPcDetailUrl())) {
            UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuDetailPO);
            uccSkuDetailPO.setSkuId(uccSkuPo.getSkuId());
            uccSkuDetailPO.setCommodityId(commodityId);
            uccSkuDetailPO.setSupplierShopId(supplierShopId);
            this.uccSkuDetailMapper.addSkuDetail(uccSkuDetailPO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNormSpuInfo().getSkuImags())) {
            List uccSkuPicPoList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getNormSpuInfo().getSkuImags()), UccSkuPicPo.class);
            uccSkuPicPoList.stream().forEach(each -> {
                each.setSkuId(uccSkuPo.getSkuId());
                each.setSupplierShopId(supplierShopId);
                each.setCreateOperId(reqBO.getUserId().toString());
                each.setSkuPicId(Long.valueOf(this.sequence.nextId()));
                if (each.getPicOrder() == null) {
                    each.setPicOrder(Integer.valueOf(1));
                }
            });
            try {
                this.uccSkuPicMapper.addskuPicList(uccSkuPicPoList);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u56fe\u7247\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNormSpuInfo().getSkuSpec())) {
            List uccSkuSpecPos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getNormSpuInfo().getSkuSpec()), UccSkuSpecPo.class);
            uccSkuSpecPos.stream().forEach(each -> {
                each.setSkuId(uccSkuPo.getSkuId());
                each.setCommodityId(uccSkuPo.getCommodityId());
                each.setSupplierShopId(supplierShopId);
                each.setCreateOperId(reqBO.getUserId().toString());
                each.setSkuSpecId(Long.valueOf(this.sequence.nextId()));
            });
            try {
                this.uccSkuSpecMapper.addSkuSpecs(uccSkuSpecPos);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u5c5e\u6027\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        if (reqBO.getNormSpuInfo().getSkuInfoPrice() != null) {
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            BeanUtils.copyProperties((Object)reqBO.getNormSpuInfo().getSkuInfoPrice(), (Object)uccSkuPricePo);
            uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPricePo.setSupplierShopId(supplierShopId);
            uccSkuPricePo.setCreateOperId(reqBO.getUserId().toString());
            uccSkuPricePo.setSkuPriceId(Long.valueOf(this.sequence.nextId()));
            if (reqBO.getNormSpuInfo().getSkuInfoPrice().getMarketPrice() != null) {
                uccSkuPricePo.setMarketPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getNormSpuInfo().getSkuInfoPrice().getMarketPrice())));
            }
            if (reqBO.getNormSpuInfo().getSkuInfoPrice().getAgreementPrice() != null) {
                uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getNormSpuInfo().getSkuInfoPrice().getAgreementPrice())));
            }
            if (reqBO.getNormSpuInfo().getSkuInfoPrice().getSalePrice() != null) {
                uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getNormSpuInfo().getSkuInfoPrice().getSalePrice())));
            }
            this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            if (uccSkuPricePo.getSwitchOn() == 1) {
                ArrayList<UccLadderPricePO> uccLadderPricePOList = new ArrayList<UccLadderPricePO>();
                UccLadderPricePO uccLadderPricePO = null;
                for (UccLadderPriceInfo each2 : reqBO.getNormSpuInfo().getSkuInfoPrice().getLadderPriceInfo()) {
                    uccLadderPricePO = new UccLadderPricePO();
                    uccLadderPricePO.setStart(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each2.getStart())));
                    if (each2.getStop() != null) {
                        uccLadderPricePO.setStop(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each2.getStop())));
                    }
                    uccLadderPricePO.setPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each2.getPrice())));
                    uccLadderPricePO.setSkuId(uccSkuPo.getSkuId());
                    uccLadderPricePO.setSupplierShopId(supplierShopId);
                    uccLadderPricePO.setSkuPriceId(uccSkuPricePo.getSkuPriceId());
                    uccLadderPricePO.setId(Long.valueOf(this.sequence.nextId()));
                    uccLadderPricePOList.add(uccLadderPricePO);
                }
                try {
                    this.uccLadderPriceMapper.batchInsert(uccLadderPricePOList);
                }
                catch (Exception e) {
                    throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u9636\u68af\u4ef7\u683c\u65b0\u589e\u5931\u8d25" + e.getMessage());
                }
            }
        }
        UccSaleNumPo saleNumPo = new UccSaleNumPo();
        saleNumPo.setSkuId(uccSkuPo.getSkuId());
        saleNumPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        saleNumPo.setSoldNumber(new BigDecimal(0));
        saleNumPo.setSaleId(Long.valueOf(this.sequence.nextId()));
        try {
            this.uccSaleNumMapper.insertSaleNum(saleNumPo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u9500\u91cf\u65b0\u589e\u5931\u8d25" + e.getMessage());
        }
        if (reqBO.getNormSpuInfo().getOnShelveWay() != null) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(supplierShopId);
            uccSkuPutCirPo.setId(Long.valueOf(this.sequence.nextId()));
            uccSkuPutCirPo.setState(Integer.valueOf(1));
            if (0 == reqBO.getNormSpuInfo().getOnShelveWay()) {
                uccSkuPutCirPo.setUpType(Integer.valueOf(1));
                uccSkuPutCirPo.setDownType(Integer.valueOf(1));
            } else {
                uccSkuPutCirPo.setUpType(Integer.valueOf(2));
                uccSkuPutCirPo.setDownType(Integer.valueOf(2));
            }
            try {
                this.uccSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u4e0a\u4e0b\u67b6\u5468\u671f\u5f02\u5e38");
            }
        }
        try {
            SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setOperateNo(reqBO.getUsername());
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
            if (reqBO.getNormSpuInfo().getTotalNum() != null) {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getNormSpuInfo().getTotalNum())));
            } else {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(0L));
            }
            smcsdkStockNumInfoBO.setSkuId(String.valueOf(uccSkuPo.getSkuId()));
            smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
            smcsdkOperateStockNumReqBO.setObjectId(String.valueOf(commodityId));
            smcsdkOperateStockNumReqBO.setObjectType("10");
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
        }
        catch (Exception e) {
            throw new ZTBusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_ADD_FAIL.code() + e.getMessage());
        }
        if (reqBO.getNormSpuInfo().getSkuExpand() != null) {
            UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
            String json2 = JSONObject.toJSONString((Object)reqBO.getNormSpuInfo().getSkuExpand(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
            uccSkuExpandPo = (UccSkuExpandPo)JSON.parseObject((String)json2, UccSkuExpandPo.class);
            uccSkuExpandPo.setSkuId(uccSkuPo.getSkuId());
            uccSkuExpandPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            try {
                this.uccSkuExpandMapper.insertSkuExpand(uccSkuExpandPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code() + "\u5355\u54c1\u6269\u5c55\u4fe1\u606f\u65b0\u589e\u5931\u8d25" + e.getMessage());
            }
        }
        if (reqBO.getOperType() == 1) {
            ArrayList<Long> skus = new ArrayList<Long>();
            skus.add(uccSkuPo.getSkuId());
            UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approveCreationAtomReqBO);
            approveCreationAtomReqBO.setObjId(skus);
            approveCreationAtomReqBO.setMenuId(this.process);
            approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_PUSH);
            approveCreationAtomReqBO.setOrderId(supplierShopId);
            approveCreationAtomReqBO.setUserId(reqBO.getUserId());
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = null;
            try {
                uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
            if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                this.updateSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus(), "", "", skus, supplierShopId, reqBO);
            } else {
                try {
                    this.updateSkuStatus(SkuStatusEnum.PENDING_APPROVAL_STATUS.getStatus(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO.toString(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
                }
            }
        }
        rspBO.setCommodityId(commodityId);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccNormSpuCreateAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

