/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrOperAgreementItemListSysnAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementItemBO;
import com.tydic.agreement.ability.bo.AgrOperAgreementItemListSysnAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrOperAgreementItemListSysnAbilityRspBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccOrgSkuMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.zone.ability.api.UccNormSpuChangeAduitAbilityService;
import com.tydic.commodity.zone.ability.bo.UccNormSpuChangeAduitAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccNormSpuChangeAduitAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccNormSpuChangeAduitBusiService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccNormSpuChangeAduitAbilityService"})
public class UccNormSpuChangeAduitAbilityServiceImpl
implements UccNormSpuChangeAduitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccNormSpuChangeAduitAbilityServiceImpl.class);
    @Autowired
    private UccNormSpuChangeAduitBusiService uccNormSpuChangeAduitBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private AgrOperAgreementItemListSysnAbilityService agrOperAgreementItemListSysnAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccOrgSkuMapper uccOrgSkuMapper;

    @PostMapping(value={"dealChangeAduit"})
    public UccNormSpuChangeAduitAbilityRspBO dealChangeAduit(@RequestBody UccNormSpuChangeAduitAbilityReqBO reqBO) {
        UccNormSpuChangeAduitAbilityRspBO rspBO = new UccNormSpuChangeAduitAbilityRspBO();
        this.checkParameter(reqBO);
        rspBO = this.uccNormSpuChangeAduitBusiService.dealChangeAduit(reqBO);
        this.syncAgrInfo(reqBO.getChanageList());
        return rspBO;
    }

    private void checkParameter(UccNormSpuChangeAduitAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getChanageList())) {
            throw new BusinessException("8888", "batchSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSkuBO uccBatchSkuBO : reqBO.getChanageList()) {
            if (Objects.isNull(uccBatchSkuBO.getSkuId())) {
                throw new BusinessException("8888", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!Objects.isNull(uccBatchSkuBO.getSupplierShopId())) continue;
            throw new BusinessException("8888", "supplierShopId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new BusinessException("8888", "auditResult\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getUserId())) {
            throw new BusinessException("8888", "userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getUsername())) {
            throw new BusinessException("8888", "userName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOrgIdIn())) {
            throw new BusinessException("8888", "orgIdIn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getOrgName())) {
            throw new BusinessException("8888", "orgName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncAgrInfo(List<UccBatchSkuBO> chanageList) {
        List skuIds = chanageList.stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
        List collect = uccSkuPos.stream().filter(bo -> bo.getVirtual() != null && bo.getVirtual() == 1).map(UccSkuPo::getSkuId).collect(Collectors.toList());
        List uccSkuAgrAgreementItemPOS = this.uccOrgSkuMapper.qrySkuAgrList(collect);
        String json = JSONArray.toJSONString((Object)uccSkuAgrAgreementItemPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        List agrAgreementItemBOs = JSONArray.parseArray((String)json, AgrAgreementItemBO.class);
        AgrOperAgreementItemListSysnAbilityReqBO agrReq = new AgrOperAgreementItemListSysnAbilityReqBO();
        agrReq.setAgrAgreementItemBOs(agrAgreementItemBOs);
        agrReq.setOperType("1");
        log.info("\u540c\u6b65\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)agrReq));
        try {
            AgrOperAgreementItemListSysnAbilityRspBO agrOperAgreementItemListSysnAbilityRspBO = this.agrOperAgreementItemListSysnAbilityService.operAgreementItemListSysn(agrReq);
            log.info("\u540c\u6b65\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)agrOperAgreementItemListSysnAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

