/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccUserdefinedSkuOntheauditAbilityService;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuOntheauditAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuOntheauditAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSkuOntheauditBusiService;
import com.tydic.commodity.zone.busi.bo.UccUserdefinedSkuOntheauditBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccUserdefinedSkuOntheauditBusiRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccUserdefinedSkuOntheauditAbilityService"})
public class UccUserdefinedSkuOntheauditAbilityServiceImpl
implements UccUserdefinedSkuOntheauditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccUserdefinedSkuOntheauditAbilityServiceImpl.class);
    @Autowired
    private UccUserdefinedSkuOntheauditBusiService uccUserdefinedSkuOntheauditBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"dealUccUserdefinedSkuOntheaudit"})
    public UccUserdefinedSkuOntheauditAbilityRspBO dealUccUserdefinedSkuOntheaudit(@RequestBody UccUserdefinedSkuOntheauditAbilityReqBO reqBO) {
        this.checkParameter(reqBO);
        UccUserdefinedSkuOntheauditBusiReqBO uccUserdefinedSkuOntheauditBusiReqBO = new UccUserdefinedSkuOntheauditBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)uccUserdefinedSkuOntheauditBusiReqBO));
        UccUserdefinedSkuOntheauditBusiRspBO uccUserdefinedSkuOntheauditBusiRspBO = this.uccUserdefinedSkuOntheauditBusiService.dealUccUserdefinedSkuOntheaudit(uccUserdefinedSkuOntheauditBusiReqBO);
        UccUserdefinedSkuOntheauditAbilityRspBO rspBO = new UccUserdefinedSkuOntheauditAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)uccUserdefinedSkuOntheauditBusiRspBO), (Object)rspBO);
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        List supplierShopIdList = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSupplierShopId).collect(Collectors.toList());
        for (Long supplierShopId : supplierShopIdList) {
            List skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skus);
            List collect = uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds((List)Lists.newArrayList(collect));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        return rspBO;
    }

    private void checkParameter(UccUserdefinedSkuOntheauditAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            throw new BusinessException("8888", "batchSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchSkuBO uccBatchSkuBO : reqBO.getBatchSkuList()) {
            if (Objects.isNull(uccBatchSkuBO.getSkuId())) {
                throw new BusinessException("8888", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!Objects.isNull(uccBatchSkuBO.getSupplierShopId())) continue;
            throw new BusinessException("8888", "supplierShopId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new BusinessException("8888", "auditResult\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getUserId())) {
            throw new BusinessException("8888", "userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOrgIdIn())) {
            throw new BusinessException("8888", "orgIdIn\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

