/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ApprovalDetailPO;
import com.tydic.commodity.zone.ability.bo.ApprovalNodeInfoBO;
import com.tydic.commodity.zone.busi.api.UccApprovalDetailBusiService;
import com.tydic.commodity.zone.busi.bo.UccApprovalDetailBusiBO;
import com.tydic.commodity.zone.busi.bo.UccApprovalDetailBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccApprovalDetailBusiRspBO;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccApprovalDetailBusiServiceImpl
implements UccApprovalDetailBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;

    @Override
    public UccApprovalDetailBusiRspBO qryApprovalDetail(UccApprovalDetailBusiReqBO param) {
        UccApprovalDetailBusiRspBO rspBO = new UccApprovalDetailBusiRspBO();
        if (param.getSkuId() == null || Objects.isNull(param.getSkuId())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
            return rspBO;
        }
        List approvalDetailPOS = this.uccSkuMapper.qryApprovalDetail(param.getSkuId());
        if (CollectionUtils.isNotEmpty((Collection)approvalDetailPOS)) {
            Map<Long, List<ApprovalDetailPO>> collect = approvalDetailPOS.stream().collect(Collectors.groupingBy(ApprovalDetailPO::getAuditOrderId));
            OptionalLong max = approvalDetailPOS.stream().mapToLong(ApprovalDetailPO::getAuditOrderId).max();
            List<ApprovalDetailPO> approvalDetail = collect.get(max.getAsLong());
            HashMap<String, UmcDycMemberBO> userInfoMap = new HashMap<String, UmcDycMemberBO>();
            UccApprovalDetailBusiBO approvalInfo = new UccApprovalDetailBusiBO();
            ArrayList<ApprovalNodeInfoBO> nodeInfo = new ArrayList<ApprovalNodeInfoBO>();
            for (int i = 0; i < approvalDetail.size(); ++i) {
                ApprovalDetailPO approvalRecord = approvalDetail.get(i);
                if (userInfoMap.get(approvalRecord.getOperId()) == null) {
                    UmcDycMemberQryDetailAbilityReqBO reqBO = new UmcDycMemberQryDetailAbilityReqBO();
                    reqBO.setMemId(Long.valueOf(Long.parseLong(approvalRecord.getOperId())));
                    UmcDycMemberQryDetailAbilityRspBO userInfo = this.umcDycMemberQryDetailAbilityService.qryMemberDetail(reqBO);
                    userInfoMap.put(approvalRecord.getOperId(), userInfo.getMemberBO());
                }
                if (i == 0) {
                    approvalInfo.setSubmitUserName(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getMemName2());
                    approvalInfo.setSubmitPhone(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getOfficePhone());
                    approvalInfo.setSubmitOrgName(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getOrgFullName());
                }
                if (approvalDetail.size() > 1 && i == approvalDetail.size() - 1) {
                    approvalInfo.setApprovalUserName(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getMemName2());
                    approvalInfo.setApprovalPhone(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getOfficePhone());
                    approvalInfo.setApprovalOrgName(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getOrgFullName());
                }
                ApprovalNodeInfoBO approvalNodeInfoBO = new ApprovalNodeInfoBO();
                approvalNodeInfoBO.setNodeUserName(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getMemName2());
                approvalNodeInfoBO.setNodeOrgName(((UmcDycMemberBO)userInfoMap.get(approvalRecord.getOperId())).getOrgFullName());
                approvalNodeInfoBO.setResult(approvalRecord.getAuditAdvice());
                approvalNodeInfoBO.setResultType(Integer.valueOf(Objects.isNull(approvalRecord.getAuditResult()) ? 0 : approvalRecord.getAuditResult()));
                approvalNodeInfoBO.setNowNodeName(StringUtils.isNotEmpty((CharSequence)approvalRecord.getStepName()) ? approvalRecord.getStepName() : "\u53d1\u8d77\u5ba1\u6279");
                approvalNodeInfoBO.setNextNodeName(approvalRecord.getNextStepName());
                approvalNodeInfoBO.setIsEnd(Integer.valueOf(StringUtils.isEmpty((CharSequence)approvalRecord.getNextStepId()) ? 0 : 1));
                approvalNodeInfoBO.setIsCreate(Integer.valueOf(i == 0 ? 0 : 1));
                nodeInfo.add(approvalNodeInfoBO);
            }
            approvalInfo.setNodeInfo(nodeInfo);
            rspBO.setApprovalInfo(approvalInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u5230\u6570\u636e");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6682\u65e0\u6570\u636e!");
        }
        return rspBO;
    }
}

