/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSkuTheUpServiceBusiService;
import com.tydic.commodity.zone.busi.bo.UccUserdefinedSkuTheUpServiceBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccUserdefinedSkuTheUpServiceBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUserdefinedSkuTheUpServiceBusiServiceImpl
implements UccUserdefinedSkuTheUpServiceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUserdefinedSkuTheUpServiceBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccUpAndOffApplyBusiService uccUpAndOffApplyBusiService;
    @Value(value="ARG_ON_SHELF_PROCESS")
    private String process;

    @Override
    public UccUserdefinedSkuTheUpServiceBusiRspBO dealUccUserdefinedSkuTheUpService(UccUserdefinedSkuTheUpServiceBusiReqBO reqBO) {
        UccUserdefinedSkuTheUpServiceBusiRspBO rspBO = new UccUserdefinedSkuTheUpServiceBusiRspBO();
        List skuIds = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
        List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
        Map<Long, UccBatchSkuBO> skuMap = reqBO.getBatchSkuList().stream().collect(Collectors.toMap(UccBatchSkuBO::getSkuId, entity -> entity));
        if (CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            throw new BusinessException("8888", "\u65e0\u6cd5\u67e5\u8be2\u5230\u5bf9\u5e94\u5546\u54c1");
        }
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            if (Objects.isNull(skuMap.get(uccSkuPo.getSkuId())) || !SkuStatusEnum.PENDING_SHELF_STATUS.getStatus().equals(uccSkuPo.getSkuStatus()) || !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.equals(uccSkuPo.getApprovalStatus())) continue;
            throw new BusinessException("8888", "\u4e0a\u67b6\u7684\u5546\u54c1\u4e2d\u5305\u542b\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5546\u54c1");
        }
        UccUpAndOffApplyAbilityReqBO busiReqBO = new UccUpAndOffApplyAbilityReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)busiReqBO);
        busiReqBO.setBatchSkuList(reqBO.getBatchSkuList());
        ExtReqBO extReqBO = new ExtReqBO();
        extReqBO.setProcess(this.process);
        extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
        ArrayList<Integer> oldStatus = new ArrayList<Integer>();
        oldStatus.add(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
        extReqBO.setStatusOld(oldStatus);
        extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
        extReqBO.setStatusApply(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
        extReqBO.setAuditStatusApply(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_ON_SHELF_GO.toString());
        extReqBO.setRemark("\u624b\u5de5\u4e0a\u67b6");
        try {
            UccUpAndOffApplyAbilityRspBO busiRspBO = this.uccUpAndOffApplyBusiService.dealUpAndOffApply(busiReqBO, extReqBO);
            BeanUtils.copyProperties((Object)busiRspBO, (Object)((Object)rspBO));
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        return rspBO;
    }
}

