/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccNewSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuTheshelvesserviceAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccUserdefinedSkuTheshelvesserviceAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSkuTheshelvesserviceBusiService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccUserdefinedSkuTheshelvesserviceBusiServiceImpl
implements UccUserdefinedSkuTheshelvesserviceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUserdefinedSkuTheshelvesserviceBusiServiceImpl.class);
    @Value(value="${ARG_OFF_SHELF_PROCESS}")
    private String process;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccNewSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;

    @Override
    public UccUserdefinedSkuTheshelvesserviceAbilityRspBO dealUccUserdefinedSkuTheshelvesservice(UccUserdefinedSkuTheshelvesserviceAbilityReqBO reqBO) {
        UccUserdefinedSkuTheshelvesserviceAbilityRspBO rspBO = new UccUserdefinedSkuTheshelvesserviceAbilityRspBO();
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        List<Object> skus = new ArrayList();
        for (Long supplierShopId : mapSku.keySet()) {
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            List collect = uccSkuPos.stream().filter(uccSkuPo -> SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(uccSkuPo.getSkuStatus()) && !ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(uccSkuPo.getApprovalStatus())).collect(Collectors.toList());
            if (collect.size() != uccSkuPos.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u5355\u54c1\u72b6\u6001\u6216\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approveCreationAtomReqBO);
            approveCreationAtomReqBO.setObjId(skus);
            approveCreationAtomReqBO.setMenuId(this.process);
            approveCreationAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
            approveCreationAtomReqBO.setOrderId(supplierShopId);
            approveCreationAtomReqBO.setUserId(reqBO.getUserId());
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = null;
            try {
                uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
            if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), "", "", skus, supplierShopId, reqBO);
                try {
                    for (Long l : skus) {
                        UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(l);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                        uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark("\u624b\u5de5\u4e0b\u67b6");
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25" + e.getMessage());
                    throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            try {
                this.updateSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.toString(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUserdefinedSkuTheshelvesserviceAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

