/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.IcascUccConstant;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccRelGroupSkuMapper;
import com.tydic.commodity.dao.UccSpuGroupMapper;
import com.tydic.commodity.po.UccRelGroupSkuPO;
import com.tydic.commodity.po.UccSpuGroupPO;
import com.tydic.commodity.zone.ability.bo.SkuInfoBO;
import com.tydic.commodity.zone.busi.api.UccUserdefinedSpuGrouptocreateBusiService;
import com.tydic.commodity.zone.busi.bo.UccUserdefinedSpuGrouptocreateBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccUserdefinedSpuGrouptocreateBusiRspBO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUserdefinedSpuGrouptocreateBusiServiceImpl
implements UccUserdefinedSpuGrouptocreateBusiService {
    @Autowired
    private UccSpuGroupMapper uccSpuGroupMapper;
    @Autowired
    private UccRelGroupSkuMapper uccRelGroupSkuMapper;

    @Override
    public UccUserdefinedSpuGrouptocreateBusiRspBO dealUccUserdefinedSpuGrouptocreate(UccUserdefinedSpuGrouptocreateBusiReqBO reqBO) {
        UccUserdefinedSpuGrouptocreateBusiRspBO rspBO = new UccUserdefinedSpuGrouptocreateBusiRspBO();
        if (IcascUccConstant.SpuGroupOperType.CREATE.equals(reqBO.getType())) {
            Long spuGroupId = this.addSpuGroupInfo(reqBO);
            if (!CollectionUtils.isEmpty(reqBO.getSkuInfo())) {
                this.addSpuGroupRelInfo(spuGroupId, reqBO.getSkuInfo());
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u521b\u5efa\u5546\u54c1\u7ec4\u6210\u529f");
            return rspBO;
        }
        if (IcascUccConstant.SpuGroupOperType.SAVE.equals(reqBO.getType())) {
            this.saveSpuGroupInfo(reqBO);
            this.saveSpuGroupRelInfo(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u4fdd\u5b58\u5546\u54c1\u7ec4\u6210\u529f");
            return rspBO;
        }
        if (IcascUccConstant.SpuGroupOperType.SUBMIT.equals(reqBO.getType())) {
            this.submitSpuGroupInfo(reqBO);
            this.saveSpuGroupRelInfo(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u63d0\u4ea4\u5546\u54c1\u7ec4\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("110002");
        rspBO.setRespDesc("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b");
        return rspBO;
    }

    private void saveSpuGroupRelInfo(UccUserdefinedSpuGrouptocreateBusiReqBO reqBO) {
        UccRelGroupSkuPO deleteUccRelGroupSkuPO = new UccRelGroupSkuPO();
        deleteUccRelGroupSkuPO.setSpuGroupId(reqBO.getSpuGroupId());
        this.uccRelGroupSkuMapper.deleteByCondition(deleteUccRelGroupSkuPO);
        if (!CollectionUtils.isEmpty(reqBO.getSkuInfo())) {
            for (SkuInfoBO skuInfoBO : reqBO.getSkuInfo()) {
                UccRelGroupSkuPO insertUccRelGroupSkuPO = new UccRelGroupSkuPO();
                BeanUtils.copyProperties((Object)skuInfoBO, (Object)insertUccRelGroupSkuPO);
                insertUccRelGroupSkuPO.setRelateId(Long.valueOf(Sequence.getInstance().nextId()));
                insertUccRelGroupSkuPO.setSpuGroupId(reqBO.getSpuGroupId());
                int insertResult = this.uccRelGroupSkuMapper.insertSelective(insertUccRelGroupSkuPO);
                if (1 == insertResult) continue;
                throw new BusinessException("110002", "\u4fdd\u5b58\u5546\u54c1\u7ec4\u5173\u8054\u5355\u54c1\u5931\u8d25");
            }
        }
    }

    private void addSpuGroupRelInfo(Long spuGroupId, List<SkuInfoBO> relSkuInfo) {
        for (SkuInfoBO skuInfoBO : relSkuInfo) {
            UccRelGroupSkuPO insertUccRelGroupSkuPO = new UccRelGroupSkuPO();
            BeanUtils.copyProperties((Object)skuInfoBO, (Object)insertUccRelGroupSkuPO);
            insertUccRelGroupSkuPO.setRelateId(Long.valueOf(Sequence.getInstance().nextId()));
            insertUccRelGroupSkuPO.setSpuGroupId(spuGroupId);
            int insertResult = this.uccRelGroupSkuMapper.insertSelective(insertUccRelGroupSkuPO);
            if (1 == insertResult) continue;
            throw new BusinessException("110002", "\u5546\u54c1\u7ec4\u5173\u8054\u5355\u54c1\u5931\u8d25");
        }
    }

    private void submitSpuGroupInfo(UccUserdefinedSpuGrouptocreateBusiReqBO reqBO) {
        UccSpuGroupPO oldUccSpuGroupPO = this.uccSpuGroupMapper.selectByPrimaryKey(reqBO.getSpuGroupId());
        if (null != oldUccSpuGroupPO) {
            UccSpuGroupPO updateUccSpuGroupPO = new UccSpuGroupPO();
            BeanUtils.copyProperties((Object)oldUccSpuGroupPO, (Object)updateUccSpuGroupPO);
            BeanUtils.copyProperties((Object)reqBO, (Object)updateUccSpuGroupPO);
            updateUccSpuGroupPO.setCommodityTypeId(reqBO.getCatalogId());
            updateUccSpuGroupPO.setCommodityTypeName(reqBO.getCatalogName());
            updateUccSpuGroupPO.setStatus(IcascUccConstant.SpuGroupStatus.APPROVE_PASS);
            updateUccSpuGroupPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
            updateUccSpuGroupPO.setUpdateOperName(reqBO.getUserName());
            updateUccSpuGroupPO.setUpdateTime(new Date());
            int updateResult = this.uccSpuGroupMapper.updateByPrimaryKeySelective(updateUccSpuGroupPO);
            if (1 != updateResult) {
                throw new BusinessException("110002", "\u63d0\u4ea4\u5546\u54c1\u7ec4\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new BusinessException("110002", "\u539f\u5546\u54c1\u7ec4\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private void saveSpuGroupInfo(UccUserdefinedSpuGrouptocreateBusiReqBO reqBO) {
        UccSpuGroupPO oldUccSpuGroupPO = this.uccSpuGroupMapper.selectByPrimaryKey(reqBO.getSpuGroupId());
        if (null != oldUccSpuGroupPO) {
            UccSpuGroupPO updateUccSpuGroupPO = new UccSpuGroupPO();
            BeanUtils.copyProperties((Object)oldUccSpuGroupPO, (Object)updateUccSpuGroupPO);
            BeanUtils.copyProperties((Object)reqBO, (Object)updateUccSpuGroupPO);
            updateUccSpuGroupPO.setCommodityTypeId(reqBO.getCatalogId());
            updateUccSpuGroupPO.setCommodityTypeName(reqBO.getCatalogName());
            updateUccSpuGroupPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
            updateUccSpuGroupPO.setUpdateOperName(reqBO.getUserName());
            updateUccSpuGroupPO.setUpdateTime(new Date());
            int updateResult = this.uccSpuGroupMapper.updateByPrimaryKeySelective(updateUccSpuGroupPO);
            if (1 != updateResult) {
                throw new BusinessException("110002", "\u4fdd\u5b58\u5546\u54c1\u7ec4\u6570\u636e\u5931\u8d25");
            }
        } else {
            throw new BusinessException("110002", "\u539f\u5546\u54c1\u7ec4\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }

    private Long addSpuGroupInfo(UccUserdefinedSpuGrouptocreateBusiReqBO reqBO) {
        Long spuGroupId = Sequence.getInstance().nextId();
        UccSpuGroupPO insertUccSpuGroupPO = new UccSpuGroupPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)insertUccSpuGroupPO);
        insertUccSpuGroupPO.setSpuGroupId(spuGroupId);
        insertUccSpuGroupPO.setCommodityTypeId(reqBO.getCatalogId());
        insertUccSpuGroupPO.setCommodityTypeName(reqBO.getCatalogName());
        insertUccSpuGroupPO.setStatus(IcascUccConstant.SpuGroupStatus.DRAFT);
        insertUccSpuGroupPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        insertUccSpuGroupPO.setCreateOperName(reqBO.getUserName());
        insertUccSpuGroupPO.setCreateTime(new Date());
        int insertResult = this.uccSpuGroupMapper.insertSelective(insertUccSpuGroupPO);
        if (1 == insertResult) {
            return spuGroupId;
        }
        throw new BusinessException("110002", "\u65b0\u589e\u5546\u54c1\u7ec4\u6570\u636e\u5931\u8d25");
    }
}

