/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.weixin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.general.ability.api.UmcBindingMemAccountAbilityService;
import com.tydic.umc.general.ability.api.UmcGetWeiXinQRCodeAbilityService;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDeleteBindAbilityService;
import com.tydic.umc.general.ability.api.UmcThirdBindQryListPageAbilityService;
import com.tydic.umc.general.ability.api.UmcWeixinLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcBindingMemAccountAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcBindingMemAccountAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcGetWeiXinQRCodeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcGetWeiXinQRCodeAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemDeleteBindAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDeleteBindAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcThirdBindQryListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcThirdBindQryListPageAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcWeixinLoginAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcWeixinLoginAbilityRspBO;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.utils.GetHttpBodyUtils;
import com.tydic.umc.security.utils.WechatMessageUtil;
import com.tydic.umc.security.utils.XmlToMapUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WeixinController {
    private static final Logger log = LoggerFactory.getLogger(WeixinController.class);
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private UmcGetWeiXinQRCodeAbilityService umcGetWeiXinQRCodeAbilityService;
    @Autowired
    private UmcBindingMemAccountAbilityService umcBindingMemAccountAbilityService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;
    @Autowired
    private UmcThirdBindQryListPageAbilityService umcThirdBindQryListPageAbilityService;
    @Autowired
    private UmcWeixinLoginAbilityService umcWeixinLoginAbilityService;
    @Autowired
    private UmcMemDeleteBindAbilityService umcMemDeleteBindAbilityService;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.topDomainCookieFlag:false}")
    private Boolean topDomainCookieFlag;
    @Value(value="${login.topDomain:a.com}")
    private String topDomain;
    @Value(value="${WX_TOKEN:123456}")
    private String WX_TOKEN = "123456";

    @RequestMapping(value={"/umc/users/signup/wx/getQRCode"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    UmcGetWeiXinQRCodeAbilityRspBO getQRCode(@RequestBody UmcGetWeiXinQRCodeAbilityReqBO reqBO) {
        return this.umcGetWeiXinQRCodeAbilityService.getQRCode(reqBO);
    }

    @RequestMapping(value={"/umc/users/signup/wx/bindingAccount"})
    @ResponseBody
    UmcBindingMemAccountAbilityRspBO bindingAccount(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcBindingMemAccountAbilityReqBO reqBO) {
        UmcBindingMemAccountAbilityRspBO rspBO;
        log.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        Cookie[] cookies = request.getCookies();
        String sessionId = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("VF_CODE_SESSION_ID")) continue;
                sessionId = cookies[i].getValue();
            }
        }
        if ("0000".equals((rspBO = this.umcBindingMemAccountAbilityService.bindingAccount(reqBO)).getRespCode())) {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String loginSource = null;
            loginSource = !StringUtils.isEmpty((CharSequence)reqBO.getLoginSource()) ? reqBO.getLoginSource() : "defaltSource";
            payload.put("loginSource", loginSource);
            Date date = new Date();
            payload.put("iat", date.getTime());
            payload.put("userId", rspBO.getUserId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getAppCode()})) {
                payload.put("appCode", reqBO.getAppCode());
            }
            String token = UmcJwt.createToken(payload);
            UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
            abilityReq.setToken(token);
            abilityReq.setUserId(rspBO.getUserId());
            abilityReq.setLoginSource(loginSource);
            UmcLoginExpTimeAbilityRspBO umcLoginExpTimeAbilityRspBO = this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
            this.umcLoginAbilityService.uniqueLogin(abilityReq);
            this.cacheService.set(token + "loginSource", (Object)loginSource, this.expTime);
            rspBO.setToken(token);
            rspBO.setLoginExpTime(umcLoginExpTimeAbilityRspBO.getExpTime());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            Cookie cookie = new Cookie("auth-token", token);
            if (this.topDomainCookieFlag.booleanValue()) {
                cookie.setDomain(this.topDomain);
            }
            cookie.setPath("/");
            response.addCookie(cookie);
            return rspBO;
        }
        throw new ZTBusinessException(rspBO.getRespDesc());
    }

    @RequestMapping(value={"/umc/users/signup/wx/qryThirdBindListPage"})
    @ResponseBody
    UmcThirdBindQryListPageAbilityRspBO qryThirdBindListPage(@RequestBody UmcThirdBindQryListPageAbilityReqBO reqBO) {
        reqBO.setOperType("1");
        return this.umcThirdBindQryListPageAbilityService.qryThirdBindListPage(reqBO);
    }

    @RequestMapping(value={"/umc/users/signup/wx/weixingLogin"})
    @ResponseBody
    UmcWeixinLoginAbilityRspBO weixingLogin(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcWeixinLoginAbilityReqBO reqBO) {
        UmcWeixinLoginAbilityRspBO rspBO = this.umcWeixinLoginAbilityService.weixingLogin(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            log.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            Cookie[] cookies = request.getCookies();
            String sessionId = null;
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals("VF_CODE_SESSION_ID")) continue;
                    sessionId = cookies[i].getValue();
                }
            }
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String loginSource = null;
            loginSource = !StringUtils.isEmpty((CharSequence)reqBO.getLoginSource()) ? reqBO.getLoginSource() : "defaltSource";
            payload.put("loginSource", loginSource);
            Date date = new Date();
            payload.put("iat", date.getTime());
            payload.put("userId", rspBO.getUserId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getAppCode()})) {
                payload.put("appCode", reqBO.getAppCode());
            }
            String token = UmcJwt.createToken(payload);
            UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
            abilityReq.setToken(token);
            abilityReq.setUserId(rspBO.getUserId());
            abilityReq.setLoginSource(loginSource);
            UmcLoginExpTimeAbilityRspBO umcLoginExpTimeAbilityRspBO = this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
            this.umcLoginAbilityService.uniqueLogin(abilityReq);
            this.cacheService.set(token + "loginSource", (Object)loginSource, this.expTime);
            rspBO.setToken(token);
            rspBO.setLoginExpTime(umcLoginExpTimeAbilityRspBO.getExpTime());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            Cookie cookie = new Cookie("auth-token", token);
            if (this.topDomainCookieFlag.booleanValue()) {
                cookie.setDomain(this.topDomain);
            }
            cookie.setPath("/");
            response.addCookie(cookie);
            return rspBO;
        }
        return null;
    }

    @GetMapping(value={"/umc/users/signup/wx/WechatCallBack"})
    @BusiResponseBody
    public String WechatCallBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = this.WX_TOKEN;
        String nonce = request.getParameter("nonce");
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        Object[] paramArr = new String[]{token, timestamp, nonce};
        Arrays.sort(paramArr);
        PrintWriter out = response.getWriter();
        String echostr = request.getParameter("echostr");
        if (WechatMessageUtil.checkSignNature((String[])paramArr, signature)) {
            log.debug("===========\u8bf7\u6c42\u6821\u9a8c\u6210\u529f========");
            out.print(echostr);
        } else {
            log.error("===========\u8bf7\u6c42\u6821\u9a8c\u5931\u8d25========");
        }
        return null;
    }

    @PostMapping(value={"/umc/users/signup/wx/WechatCallBack"})
    @ResponseBody
    public String wxCallBack(HttpServletRequest request) {
        log.debug("\u5f00\u59cb\u8c03\u7528\u56de\u8c03\u670d\u52a1");
        String body = GetHttpBodyUtils.getBody(request);
        Map<String, String> map = XmlToMapUtils.toMap(body);
        log.debug("chu\u53c2:" + map);
        System.out.println("=========wxPushMessage===========" + map);
        if (null != map) {
            String toUserName = map.get("ToUserName");
            String fromUserName = map.get("FromUserName");
            String createTime = map.get("CreateTime");
            String msgType = map.get("MsgType");
            String event = map.get("Event");
            String eventKey = map.get("EventKey");
            String ticket = map.get("Ticket");
            if (null != event && ("subscribe".equals(event) || "SCAN".equals(event))) {
                log.debug("openId:" + fromUserName);
                log.debug("toUserName:" + toUserName);
                log.debug("createTime:" + createTime);
                log.debug("msgType:" + msgType);
                log.debug("eventKey:" + eventKey);
                log.debug("ticket:" + ticket);
                Object obj = this.cacheService.get(ticket);
                Long time = Long.valueOf(String.valueOf(obj));
                this.cacheService.delete(ticket + time);
                this.cacheService.set(ticket + time, (Object)fromUserName);
                return "";
            }
            if (null != event && "unsubscribe".equals(event)) {
                UmcMemDeleteBindAbilityReqBO abilityReqBO = new UmcMemDeleteBindAbilityReqBO();
                abilityReqBO.setOpenId(fromUserName);
                UmcMemDeleteBindAbilityRspBO abilityRspBO = this.umcMemDeleteBindAbilityService.deleteMemBind(abilityReqBO);
                if (!"0000".equals(abilityRspBO.getRespCode())) {
                    throw new ZTBusinessException(abilityRspBO.getRespDesc());
                }
                return "";
            }
            return "";
        }
        return "";
    }

    private Map<String, String> xmlToMap(HttpServletRequest httpServletRequest) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ServletInputStream inputStream = httpServletRequest.getInputStream();
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)inputStream);
            Element root = document.getRootElement();
            List elementList = root.elements();
            for (Element e : elementList) {
                log.debug("map:" + JSONObject.toJSONString((Object)e));
                map.put(e.getName(), e.getText());
            }
            inputStream.close();
            inputStream = null;
            return map;
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    @RequestMapping(value={"/umc/users/signup/wx/getOpenId"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    UmcGetWeiXinQRCodeAbilityRspBO getOpenId(@RequestBody UmcGetWeiXinQRCodeAbilityReqBO reqBO) {
        UmcGetWeiXinQRCodeAbilityRspBO rspBO = new UmcGetWeiXinQRCodeAbilityRspBO();
        rspBO.setOpenId(String.valueOf(this.cacheService.get(reqBO.getTicket() + reqBO.getTime())));
        return rspBO;
    }
}

