/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.filter.ParameterRequestWrapper;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umc.security.utils.RegexUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class UmcTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTokenAuthenticationFilter.class);
    @Value(value="${static.resources}")
    private String staticResources;
    @Value(value="${login.expTime:7200}")
    private Long expTime;
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Autowired
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        Cookie[] cookies;
        String token = request.getHeader("auth-token");
        if (StringUtils.isEmpty((CharSequence)token) && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("auth-token")) continue;
                token = cookies[i].getValue();
            }
        }
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject datajsonObject = new com.alibaba.fastjson.JSONObject();
        LOGGER.debug("\u83b7\u53d6\u5f53\u524dtocken" + token);
        if (token != null) {
            UmcLoginExpTimeAbilityReqBO reqBO = new UmcLoginExpTimeAbilityReqBO();
            reqBO.setToken(token);
            UmcLoginExpTimeAbilityRspBO rspBO = this.umcLoginAbilityService.getLoginExpTime(reqBO);
            Long loginExpTime = 0L;
            LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)rspBO));
            if ("0000".equals(rspBO.getRespCode())) {
                loginExpTime = rspBO.getExpTime();
                LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
            }
            Map<String, Object> resultMap = UmcJwt.validToken(token, loginExpTime);
            UmcTokenState state = UmcTokenState.getTokenState((String)resultMap.get("state"));
            switch (state) {
                case VALID: {
                    JSONObject data = (JSONObject)resultMap.get("data");
                    request.setAttribute("data", (Object)data);
                    String appCode = data.getAsString("appCode");
                    reqBO.setUserId((Long)data.get((Object)"userId"));
                    reqBO.setLoginSource((String)data.get((Object)"loginSource"));
                    this.umcLoginAbilityService.updateLoginExpTime(reqBO);
                    UmcUserDetails user = this.getUserInfoByTokenService.getUserInfoByUserId((Long)data.get((Object)"userId"), token, appCode, request.getRequestURI());
                    if ("0000".equals(user.getRespCode())) {
                        return new UsernamePasswordAuthenticationToken((Object)user.getUserDetails(), (Object)user.getUserDetails().getPassword(), user.getUserDetails().getAuthorities());
                    }
                    datajsonObject.put("respCode", (Object)user.getRespCode());
                    datajsonObject.put("respDesc", (Object)user.getRespDesc());
                    jsonObject.put("data", (Object)datajsonObject);
                    LOGGER.info(user.getRespCode());
                    break;
                }
                case EXPIRED: {
                    datajsonObject.put("respCode", (Object)"AE401");
                    datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)datajsonObject);
                    break;
                }
                default: {
                    datajsonObject.put("respCode", (Object)"AE401");
                    datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                    jsonObject.put("data", (Object)datajsonObject);
                    break;
                }
            }
        } else {
            datajsonObject.put("respCode", (Object)"AE401");
            datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            jsonObject.put("data", (Object)datajsonObject);
        }
        if ("AE403".equals(datajsonObject.getString("respCode"))) {
            response.setStatus(403);
        } else {
            response.setStatus(401);
        }
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequest requestWrapper = null;
        String url = request.getRequestURI();
        boolean needToken = true;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/**/noauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        allowSessionCreation.set(true);
        if (needToken) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            requestWrapper = this.parameterRequest(request.getHeader("auth-token"), request, response);
        }
        if (requestWrapper == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOGGER.debug("UmcUserInfoWrapperFilter---1\uff1a");
        } else {
            LOGGER.debug("UmcUserInfoWrapperFilter---2\uff1a");
            chain.doFilter(requestWrapper, (ServletResponse)response);
        }
    }

    private ServletRequest parameterRequest(String token, HttpServletRequest request, HttpServletResponse response) {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        ParameterRequestWrapper requestWrapper = null;
        if (userInfo != null) {
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            if (userInfo.getUserId() != null && request instanceof HttpServletRequest) {
                LOGGER.debug("UmcUserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
                requestWrapper = new ParameterRequestWrapper(request);
            }
        }
        LOGGER.debug("UmcUserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

