/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.weixin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.sensorsdata.analytics.javasdk.SensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.consumer.ConcurrentLoggingConsumer;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.tydic.umc.general.ability.api.UmcBindingMemAccountAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseMessageAbilityService;
import com.tydic.umc.general.ability.api.UmcGetWeiXinQRCodeAbilityService;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.api.UmcLoginWeiXinBindAccountAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDeleteBindAbilityService;
import com.tydic.umc.general.ability.api.UmcThirdBindQryListPageAbilityService;
import com.tydic.umc.general.ability.api.UmcWeixinLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcBindingMemAccountAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcBindingMemAccountAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseMessageAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcGetWeiXinQRCodeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcGetWeiXinQRCodeAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcLoginWeiXinBindAccountAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcLoginWeiXinBindAccountAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemDeleteBindAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDeleteBindAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcThirdBindQryListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcThirdBindQryListPageAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcWeixinLoginAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcWeixinLoginAbilityRspBO;
import com.tydic.umc.security.base.Token;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umc.security.utils.GetHttpBodyUtils;
import com.tydic.umc.security.utils.HttpClientUtil;
import com.tydic.umc.security.utils.WechatMessageUtil;
import com.tydic.umc.security.utils.XmlToMapUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class WeixinController {
    private static final Logger log = LoggerFactory.getLogger(WeixinController.class);
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private UmcGetWeiXinQRCodeAbilityService umcGetWeiXinQRCodeAbilityService;
    @Autowired
    private UmcBindingMemAccountAbilityService umcBindingMemAccountAbilityService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;
    @Autowired
    private UmcThirdBindQryListPageAbilityService umcThirdBindQryListPageAbilityService;
    @Autowired
    private UmcWeixinLoginAbilityService umcWeixinLoginAbilityService;
    @Autowired
    private UmcLoginWeiXinBindAccountAbilityService umcLoginWeiXinBindAccountAbilityService;
    @Autowired
    private UmcMemDeleteBindAbilityService umcMemDeleteBindAbilityService;
    @Autowired
    private UmcEnterpriseMessageAbilityService umcSendWeChatMessageAbilityService;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.topDomainCookieFlag:false}")
    private Boolean topDomainCookieFlag;
    @Value(value="${login.topDomain:a.com}")
    private String topDomain;
    @Value(value="${WX_TOKEN:123456}")
    private String WX_TOKEN = "123456";
    @Value(value="${login.originalKey:12345678901234561234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${WX_APP_ID:cs-appid}")
    private String WX_APP_ID;
    @Value(value="${WX_SECRET:DEV.icasc.cn}")
    private String WX_SECRET;
    private final String token_url = "http://open.dev.icasc.cn/api/weixin/scanLogin/getAccessToken?grant_type=client_credential&appid=APPID&secret=SECRET";
    private final String news_url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=ACCESS_TOKEN";
    @Value(value="${loginCount:6}")
    private Integer loginCount;
    @Value(value="${tracking.log.address}")
    private String TRACKING_LOG_ADDRESS;

    @RequestMapping(value={"/umc/users/signup/wx/getQRCode"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    UmcGetWeiXinQRCodeAbilityRspBO getQRCode(@RequestBody UmcGetWeiXinQRCodeAbilityReqBO reqBO) {
        return this.umcGetWeiXinQRCodeAbilityService.getQRCode(reqBO);
    }

    @RequestMapping(value={"/umc/users/signup/wx/bindLoginWeiXin"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    UmcLoginWeiXinBindAccountAbilityRspBO bindLoginWeiXin(@RequestBody UmcLoginWeiXinBindAccountAbilityReqBO reqBO) {
        return this.umcLoginWeiXinBindAccountAbilityService.bindLoginWeiXin(reqBO);
    }

    @RequestMapping(value={"/umc/users/signup/wx/bindingAccount"})
    @BusiResponseBody
    UmcBindingMemAccountAbilityRspBO bindingAccount(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcBindingMemAccountAbilityReqBO reqBO) {
        String pwd = AesUtil.decryptStr(reqBO.getPassword(), this.ORIGINAL_KEY);
        log.debug("\u660e\u6587:{}", (Object)pwd);
        reqBO.setPassword(pwd);
        log.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        Cookie[] cookies = request.getCookies();
        String sessionId = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("VF_CODE_SESSION_ID")) continue;
                sessionId = cookies[i].getValue();
            }
        }
        reqBO.setAgent(request.getHeader("user-agent").trim().replaceAll(" ", "").replaceAll("like", ""));
        UmcBindingMemAccountAbilityRspBO rspBO = this.umcBindingMemAccountAbilityService.bindingAccount(reqBO);
        if (rspBO.getRespCode().equals("8888")) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        if (reqBO.getLoginOrgType().equals("1") && rspBO.getRespCode().equals("3366")) {
            throw new ZTBusinessException("\u8be5\u8d26\u6237\u4e0d\u662f\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u8bf7\u53bb\u5f80\u6307\u5b9a\u9875\u9762\u767b\u9646");
        }
        if (reqBO.getLoginOrgType().equals("2") && rspBO.getRespCode().equals("3377")) {
            throw new ZTBusinessException("\u8be5\u8d26\u6237\u662f\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u8bf7\u53bb\u5f80\u6307\u5b9a\u4f9b\u5e94\u5546\u9875\u9762\u767b\u9646");
        }
        if ("0000".equals(rspBO.getRespCode())) {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String loginSource = null;
            loginSource = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getLoginSource()) ? reqBO.getLoginSource() : "defaltSource";
            payload.put("loginSource", loginSource);
            Date date = new Date();
            payload.put("iat", date.getTime());
            payload.put("userId", rspBO.getUserId());
            if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getAppCode()})) {
                payload.put("appCode", reqBO.getAppCode());
            }
            String token = UmcJwt.createToken(payload);
            UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
            abilityReq.setToken(token);
            abilityReq.setUserId(rspBO.getUserId());
            abilityReq.setLoginSource(loginSource);
            UmcLoginExpTimeAbilityRspBO umcLoginExpTimeAbilityRspBO = this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
            this.umcLoginAbilityService.uniqueLogin(abilityReq);
            this.cacheService.set(token + "loginSource", (Object)loginSource, this.expTime);
            rspBO.setToken(token);
            rspBO.setLoginExpTime(umcLoginExpTimeAbilityRspBO.getExpTime());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            Cookie cookie = new Cookie("auth-token", token);
            if (this.topDomainCookieFlag.booleanValue()) {
                cookie.setDomain(this.topDomain);
            }
            cookie.setPath("/");
            response.addCookie(cookie);
            return rspBO;
        }
        throw new ZTBusinessException(rspBO.getRespDesc());
    }

    @RequestMapping(value={"/umc/users/signup/wx/qryThirdBindListPage"})
    @BusiResponseBody
    UmcThirdBindQryListPageAbilityRspBO qryThirdBindListPage(@RequestBody UmcThirdBindQryListPageAbilityReqBO reqBO) {
        reqBO.setOperType("1");
        return this.umcThirdBindQryListPageAbilityService.qryThirdBindListPage(reqBO);
    }

    @RequestMapping(value={"/umc/users/signup/wx/weixingLogin"})
    @BusiResponseBody
    UmcWeixinLoginAbilityRspBO weixingLogin(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcWeixinLoginAbilityReqBO reqBO, @CookieValue(value="sensorsdata2015jssdkcross", required=false) String sensorsdata) {
        Integer residualTimes;
        reqBO.setAgent(request.getHeader("user-agent").trim().replaceAll(" ", "").replaceAll("like", ""));
        Long userId = null;
        String account = reqBO.getLoginName();
        String login_method = "\u5fae\u4fe1";
        String verification_method = "\u5fae\u4fe1\u626b\u7801";
        boolean is_quick_login = false;
        boolean is_success = true;
        String fail_reason = "";
        UmcWeixinLoginAbilityRspBO rspBO = this.umcWeixinLoginAbilityService.weixingLogin(reqBO);
        if ("161012".equals(rspBO.getRespCode())) {
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, rspBO.getRespDesc());
            throw new ZTBusinessException("\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        userId = rspBO.getUserId();
        String template = "";
        if (reqBO.getLoginOrgType().equals("1") && rspBO.getRespCode().equals("8888")) {
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, "\u8be5\u8d26\u6237\u4e0d\u662f\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u8bf7\u53bb\u5f80\u6307\u5b9a\u9875\u9762\u767b\u9646");
            throw new ZTBusinessException("\u8be5\u8d26\u6237\u4e0d\u662f\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u8bf7\u53bb\u5f80\u6307\u5b9a\u9875\u9762\u767b\u9646");
        }
        if (reqBO.getLoginOrgType().equals("2") && rspBO.getRespCode().equals("8888")) {
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, "\u8be5\u8d26\u6237\u662f\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u8bf7\u53bb\u5f80\u6307\u5b9a\u4f9b\u5e94\u5546\u9875\u9762\u767b\u9646");
            throw new ZTBusinessException("\u8be5\u8d26\u6237\u662f\u4f9b\u5e94\u5546\u7528\u6237\uff0c\u8bf7\u53bb\u5f80\u6307\u5b9a\u4f9b\u5e94\u5546\u9875\u9762\u767b\u9646");
        }
        Integer num = (Integer)this.cacheService.get("cas" + reqBO.getLoginName());
        if (null == num) {
            num = 0;
        }
        if ((residualTimes = Integer.valueOf(this.loginCount - num)) <= 0) {
            rspBO.setLockFlag("Y");
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, "\u8d26\u6237\u5df2\u9501\u5b9a");
            return rspBO;
        }
        if ("Y".equals(rspBO.getLockFlag())) {
            rspBO.setLockFlag("Y");
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, "\u8d26\u6237\u5df2\u9501\u5b9a");
            return rspBO;
        }
        rspBO.setLockFlag("N");
        if ("0000".equals(rspBO.getRespCode())) {
            log.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String loginSource = null;
            loginSource = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getLoginSource()) ? reqBO.getLoginSource() : "defaltSource";
            payload.put("loginSource", loginSource);
            Date date = new Date();
            payload.put("iat", date.getTime());
            payload.put("userId", rspBO.getUserId());
            if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getAppCode()})) {
                payload.put("appCode", reqBO.getAppCode());
            }
            String token = UmcJwt.createToken(payload);
            UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
            abilityReq.setToken(token);
            abilityReq.setUserId(rspBO.getUserId());
            abilityReq.setLoginSource(loginSource);
            UmcLoginExpTimeAbilityRspBO umcLoginExpTimeAbilityRspBO = this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
            this.umcLoginAbilityService.uniqueLogin(abilityReq);
            this.cacheService.set(token + "loginSource", (Object)loginSource, this.expTime);
            rspBO.setToken(token);
            rspBO.setLoginExpTime(umcLoginExpTimeAbilityRspBO.getExpTime());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            Cookie cookie = new Cookie("auth-token", token);
            if (this.topDomainCookieFlag.booleanValue()) {
                cookie.setDomain(this.topDomain);
            }
            cookie.setPath("/");
            response.addCookie(cookie);
            template = "\u60a8\u597d\uff0c\u6b22\u8fce\uff01\u60a8\u5df2\u6210\u529f\u767b\u5f55\u822a\u5929\u7535\u5b50\u8d85\u5e02\u7f51\u9875\u7aef\uff0c\u60a8\u53ef\u4ee5\u4e2a\u4eba\u4e2d\u5fc3\u53bb\u7ed1\u5b9a\u5176\u4ed6\u7684\u8d26\u53f7\u3002";
            this.sendWeChatMessage(rspBO.getMemId(), template);
            return rspBO;
        }
        try {
            template = "\u60a8\u597d\uff0c\u60a8\u767b\u5f55\u822a\u5929\u7535\u5b50\u8d85\u5e02\u7f51\u9875\u7aef\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\u767b\u5f55\uff01";
            this.sendWeChatMessage(rspBO.getMemId(), template);
        }
        catch (Exception e) {
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new ZTBusinessException("\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if ("4002".equals(rspBO.getRespCode())) {
            this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, false, "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new ZTBusinessException("\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        this.searchTracking(userId, account, sensorsdata, login_method, verification_method, is_quick_login, is_success, fail_reason);
        return null;
    }

    @GetMapping(value={"/umc/users/signup/wx/WechatCallBack"})
    @BusiResponseBody
    public String WechatCallBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("\u8bf7\u6c42\u8fdb\u5165");
        String token = this.WX_TOKEN;
        String nonce = request.getParameter("nonce");
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        Object[] paramArr = new String[]{token, timestamp, nonce};
        Arrays.sort(paramArr);
        PrintWriter out = response.getWriter();
        String echostr = request.getParameter("echostr");
        if (WechatMessageUtil.checkSignNature((String[])paramArr, signature)) {
            log.debug("===========\u8bf7\u6c42\u6821\u9a8c\u6210\u529f========");
            out.print(echostr);
        } else {
            log.error("===========\u8bf7\u6c42\u6821\u9a8c\u5931\u8d25========");
        }
        log.debug("\u8bf7\u6c42\u7ed3\u675f");
        return null;
    }

    @PostMapping(value={"/umc/users/signup/wx/WechatCallBack"})
    @BusiResponseBody
    public String wxCallBack(HttpServletRequest request) {
        log.debug("\u5f00\u59cb\u8c03\u7528\u56de\u8c03\u670d\u52a1");
        String body = GetHttpBodyUtils.getBody(request);
        Map<String, String> map = XmlToMapUtils.toMap(body);
        log.debug("chu\u53c2:" + map);
        System.out.println("=========wxPushMessage===========" + map);
        if (null != map) {
            String fromUserName = map.get("FromUserName");
            this.cacheService.set(fromUserName + "count", (Object)"0", 60);
            Object o = this.cacheService.get(fromUserName + "count");
            log.debug("\u51fa\u53c2redis:" + o);
            if (null != o && "1".equals(String.valueOf(o))) {
                return "";
            }
            log.debug("==============");
            this.cacheService.delete(fromUserName + "count");
            this.cacheService.set(fromUserName + "count", (Object)1, 60);
            String toUserName = map.get("ToUserName");
            String createTime = map.get("CreateTime");
            String msgType = map.get("MsgType");
            String event = map.get("Event");
            String eventKey = map.get("EventKey");
            String ticket = map.get("Ticket");
            log.debug("\u4e8b\u4ef6\uff1a" + event);
            if (null != event && ("subscribe".equals(event) || "SCAN".equals(event))) {
                log.debug("openId:" + fromUserName);
                log.debug("toUserName:" + toUserName);
                log.debug("createTime:" + createTime);
                log.debug("msgType:" + msgType);
                log.debug("eventKey:" + eventKey);
                log.debug("ticket:" + ticket);
                Object obj = this.cacheService.get(ticket);
                Long time = Long.valueOf(String.valueOf(obj));
                this.cacheService.delete(ticket + time);
                this.cacheService.set(ticket + time, (Object)fromUserName, 600);
                log.debug("\u89e3\u6790\u6570\u636e\uff1a===========");
                UmcThirdBindQryListPageAbilityReqBO abilityReqBO = new UmcThirdBindQryListPageAbilityReqBO();
                abilityReqBO.setAuthId(fromUserName);
                UmcThirdBindQryListPageAbilityRspBO abilityRspBO = this.umcThirdBindQryListPageAbilityService.qryThirdBindListPage(abilityReqBO);
                if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                    String template = "Hi,\u5982\u60a8\u5728\u5e73\u53f0\u9996\u9875\u626b\u7801\uff0c\u8bf7\u5728\u7535\u8111\u7f51\u9875\u7aef\uff0c\u8f93\u5165\u60a8\u8981\u7ed1\u5b9a\u7684\u64cd\u4f5c\u5458/\u7ba1\u7406\u5458\u8d26\u53f7\u5bc6\u7801\uff0c\u5b8c\u6210\u7ed1\u5b9a\u3002\u7ed1\u5b9a\u540e\u53ef\u4f7f\u7528\u5fae\u4fe1\u626b\u7801\u8fdb\u884c\u767b\u5f55\u3002";
                    this.send(template, fromUserName);
                }
                this.cacheService.delete(fromUserName + "count");
                this.cacheService.set(fromUserName + "count", (Object)1, 60);
                return "";
            }
            if (null != event && "unsubscribe".equals(event)) {
                UmcMemDeleteBindAbilityReqBO abilityReqBO = new UmcMemDeleteBindAbilityReqBO();
                abilityReqBO.setOpenId(fromUserName);
                UmcMemDeleteBindAbilityRspBO abilityRspBO = this.umcMemDeleteBindAbilityService.deleteMemBind(abilityReqBO);
                if (!"0000".equals(abilityRspBO.getRespCode())) {
                    throw new ZTBusinessException(abilityRspBO.getRespDesc());
                }
                return "";
            }
            return "";
        }
        return "";
    }

    private Map<String, String> xmlToMap(HttpServletRequest httpServletRequest) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ServletInputStream inputStream = httpServletRequest.getInputStream();
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)inputStream);
            Element root = document.getRootElement();
            List elementList = root.elements();
            for (Element e : elementList) {
                log.debug("map:" + JSONObject.toJSONString((Object)e));
                map.put(e.getName(), e.getText());
            }
            inputStream.close();
            inputStream = null;
            return map;
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    @RequestMapping(value={"/umc/users/signup/wx/getOpenId"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    UmcGetWeiXinQRCodeAbilityRspBO getOpenId(@RequestBody UmcGetWeiXinQRCodeAbilityReqBO reqBO) {
        UmcGetWeiXinQRCodeAbilityRspBO rspBO = new UmcGetWeiXinQRCodeAbilityRspBO();
        rspBO.setOpenId(String.valueOf(this.cacheService.get(reqBO.getTicket() + reqBO.getTime())));
        return rspBO;
    }

    public boolean send(String template, String authId) {
        Token token = this.getTokenByAppidAndAppsecret();
        if (null != token && !"".equals(token)) {
            String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=ACCESS_TOKEN".replace("ACCESS_TOKEN", token.getAccessToken());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("touser", (Object)authId);
            jsonObject.put("msgtype", (Object)"text");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("content", template);
            jsonObject.put("text", data);
            String str = JSONObject.toJSONString((Object)jsonObject);
            log.info("***************\u53d1\u6d88\u606f\u7684\u53c2\u6570******************{}", (Object)str);
            String doPostSSLResult = HttpClientUtil.doPostSSL(requestUrl, str);
            log.info("***************\u53d1\u9001\u6d88\u606f******************{}", (Object)doPostSSLResult);
            JSONObject jsonObjectRsp = JSONObject.parseObject((String)doPostSSLResult);
            return null != jsonObjectRsp;
        }
        log.error("WxHelper.send() \u4e2d token \u4e3a\u7a7a");
        return false;
    }

    private Token getTokenByAppidAndAppsecret() {
        Token token = null;
        log.debug("ID:" + this.WX_APP_ID);
        log.debug("\u5bc6\u94a5\uff1a" + this.WX_SECRET);
        String requestUrl = "http://open.dev.icasc.cn/api/weixin/scanLogin/getAccessToken?grant_type=client_credential&appid=APPID&secret=SECRET".replace("APPID", this.WX_APP_ID).replace("SECRET", this.WX_SECRET);
        String result = HttpClientUtil.doGet(requestUrl);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        log.info("\u83b7\u53d6Token\u8fd4\u56de\u7ed3\u679c----->;getTokenByAppidAndAppsecret:" + jsonObject);
        if (null != jsonObject) {
            token = new Token();
            String access_token = jsonObject.getString("access_token");
            if (null != access_token && !"".equals(access_token)) {
                token.setAccessToken(access_token);
                token.setExpiresIn(jsonObject.getIntValue("expires_in"));
            } else {
                token = null;
                log.error("\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}", (Object)jsonObject.getIntValue("errcode"), (Object)jsonObject.getString("errmsg"));
            }
        }
        return token;
    }

    @Async
    public void sendWeChatMessage(Long memId, String template) {
        UmcEnterpriseMessageAbilityReqBO reqBO = new UmcEnterpriseMessageAbilityReqBO();
        reqBO.setMemId(memId);
        reqBO.setTemplate(template);
        this.umcSendWeChatMessageAbilityService.sendMessage(reqBO);
    }

    public void searchTracking(Long userId, String account, String sensorsdata, String login_method, String verification_method, boolean is_quick_login, boolean is_success, String fail_reason) {
        log.info("\u91c7\u8d2d\u4e13\u533a\u641c\u7d22\u529f\u80fd\u5165\u53c2\u83b7\u53d6-sensorsdata2015jssdkcross=" + sensorsdata);
        String distinctId = "ABCDEF123456789";
        if (StringUtils.isEmpty((Object)sensorsdata)) {
            JSONObject parseObject = JSON.parseObject((String)sensorsdata);
            distinctId = (String)parseObject.get((Object)"distinct_id");
        }
        if (userId != null) {
            distinctId = String.valueOf(userId);
        }
        boolean isLogin = userId != null ? Boolean.TRUE : Boolean.FALSE;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("platform", "PC\u7aef");
        map.put("account", account);
        map.put("login_method", login_method);
        map.put("verification_method", verification_method);
        map.put("is_quick_login", false);
        map.put("is_success", is_success);
        map.put("fail_reason", fail_reason);
        SensorsAnalytics sa = new SensorsAnalytics((Consumer)new ConcurrentLoggingConsumer(this.TRACKING_LOG_ADDRESS));
        SuperPropertiesRecord propertiesRecord = null;
        try {
            propertiesRecord = SuperPropertiesRecord.builder().addProperty("app_name", "\u7535\u5b50\u8d85\u5e02").addProperty("all_is_login", userId != null ? "\u662f" : "\u5426").addProperty("is_vip", "\u5426").addProperty("vip_level", "\u666e\u901a\u7528\u6237").build();
            sa.registerSuperProperties(propertiesRecord);
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        EventRecord searchRecord = null;
        try {
            searchRecord = EventRecord.builder().setDistinctId(distinctId).isLoginId(Boolean.valueOf(isLogin)).setEventName("dzcsLoginResult").addProperties(map).build();
            sa.track(searchRecord);
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        sa.shutdown();
    }
}

