/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 10000;

    public static String doGet(String url) {
        return HttpClientUtil.doGet(url, new HashMap<String, Object>(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, Object> params, boolean isHttps) {
        CloseableHttpResponse response = null;
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                param.append("?");
            } else {
                param.append("&");
            }
            param.append(key).append("=").append(params.get(key));
            ++i;
        }
        apiUrl = apiUrl + param;
        String result = null;
        CloseableHttpClient httpclient = null;
        httpclient = isHttps ? HttpClientUtil.createSSLClientDefault() : HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(apiUrl);
            response = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            System.out.println("\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String doPost(String apiUrl) {
        return HttpClientUtil.doPost(apiUrl, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String apiUrl, Map<String, Object> params) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            System.out.println("\u6267\u884c\u72b6\u6001\u7801 : " + response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String apiUrl, Object json, Map<String, String> header) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            if (header != null) {
                for (String key : header.keySet()) {
                    httpPost.setHeader(key, header.get(key));
                }
            }
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            System.out.println("\u6267\u884c\u72b6\u6001\u7801 : " + response.getStatusLine().getStatusCode());
            if (entity != null) {
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("utf-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Map.Entry<String, Object> entry;
                entry = null;
                return entry;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostSSL(String apiUrl, Object json) {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return sslsf;
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }

    static {
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(10000);
        configBuilder.setSocketTimeout(50000);
        configBuilder.setConnectionRequestTimeout(10000);
        requestConfig = configBuilder.build();
    }
}

