/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfConfirmCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebIntfConfirmCancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfConfirmCancelOrderRspBO;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebIntfConfirmCancelOrderAbilityServiceImpl
implements PebIntfConfirmCancelOrderAbilityService {
    private Logger logger = LoggerFactory.getLogger(PebIntfConfirmCancelOrderAbilityService.class);

    @Override
    public PebIntfConfirmCancelOrderRspBO confirmCancelOrder(PebIntfConfirmCancelOrderReqBO reqBO) {
        PebIntfConfirmCancelOrderRspBO rspBO;
        try {
            String reqStr = this.initPostStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_CONFIRM_CANCEL_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u5f85\u53d1\u8d27\u53d6\u6d88\u8ba2\u5355\u786e\u8ba4\u901a\u77e5[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_CONFIRM_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528ESB\u5f85\u53d1\u8d27\u53d6\u6d88\u8ba2\u5355\u786e\u8ba4\u901a\u77e5\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528ESB\u5f85\u53d1\u8d27\u53d6\u6d88\u8ba2\u5355\u786e\u8ba4\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("6000", "\u8c03\u7528ESB\u5f85\u53d1\u8d27\u53d6\u6d88\u8ba2\u5355\u786e\u8ba4\u901a\u77e5\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(PebIntfConfirmCancelOrderReqBO reqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupId()));
        String esbReqParam = ESBParamUtil.getEsbReqParam((Object)reqBO, (String)hsn, (String)"BUSINESS_ORDER");
        this.logger.debug("\u5f85\u53d1\u8d27\u53d6\u6d88\u8ba2\u5355\u786e\u8ba4\u901a\u77e5\u5165\u53c2" + esbReqParam);
        return esbReqParam;
    }

    private PebIntfConfirmCancelOrderRspBO resolveRsp(String returnString) {
        this.logger.debug("\u8c03\u7528\u5f85\u53d1\u8d27\u53d6\u6d88\u8ba2\u5355\u786e\u8ba4\u901a\u77e5\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        PebIntfConfirmCancelOrderRspBO rspBO = new PebIntfConfirmCancelOrderRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        rspBO.setResult(jsonObject.getBoolean("success"));
        return rspBO;
    }
}

