/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.JsonUtils;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfQryDeliveryInfoBusiService;
import com.tydic.uoc.busibase.busi.bo.DeliveryItemsBO;
import com.tydic.uoc.busibase.busi.bo.QryDeliveryInfoReqBO;
import com.tydic.uoc.busibase.busi.bo.QryDeliveryInfoRspBO;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfQryDeliveryInfoBusiService")
public class PebIntfQryDeliveryInfoBusiServiceImpl
implements PebIntfQryDeliveryInfoBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryDeliveryInfoBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @Override
    public QryDeliveryInfoRspBO qryDeliveryInfo(QryDeliveryInfoReqBO qryDeliveryInfoReqBO) {
        QryDeliveryInfoRspBO rspBO;
        try {
            String reqStr = this.initPostStr(qryDeliveryInfoReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_PACKAGE_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u52a1\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], " + "[http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_PACKAGE_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("2001", "\u8c03\u7528ESB\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("6000", "\u8c03\u7528ESB\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(QryDeliveryInfoReqBO qryDeliveryInfoReqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + qryDeliveryInfoReqBO.getSupplierId()));
        String esbReqParam = ESBParamUtil.getEsbReqParam((Object)qryDeliveryInfoReqBO, (String)hsn, (String)"BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606fESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private QryDeliveryInfoRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606fESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        QryDeliveryInfoRspBO rspBO = new QryDeliveryInfoRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            if (null != jsonObject.get((Object)"result")) {
                String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
                String packageId = (String)JSONObject.parseObject((String)jsonStr).get((Object)"packageId");
                String orderId = (String)JSONObject.parseObject((String)jsonStr).get((Object)"orderId");
                String deliveryCode = (String)JSONObject.parseObject((String)jsonStr).get((Object)"deliveryCode");
                String deliveryTime = (String)JSONObject.parseObject((String)jsonStr).get((Object)"deliverytime");
                String deliveryName = (String)JSONObject.parseObject((String)jsonStr).get((Object)"deliveryName");
                String deliveryItems = JSONObject.toJSONString((Object)JSONObject.parseObject((String)jsonStr).get((Object)"deliveryItems"));
                DeliveryItemsBO[] jsonStringToJavaBean = (DeliveryItemsBO[])JsonUtils.jsonStringToJavaBean((String)deliveryItems, DeliveryItemsBO[].class);
                List<DeliveryItemsBO> asList = Arrays.asList(jsonStringToJavaBean);
                rspBO.setDeliveryItems(asList);
                rspBO.setPackageId(packageId);
                rspBO.setOrderId(orderId);
                rspBO.setDeliveryCode(deliveryCode);
                rspBO.setDeliverytime(deliveryTime);
                rspBO.setDeliveryName(deliveryName);
            }
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

