/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfQryTransportFeeAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryTransportFeeBusiService;
import com.tydic.uoc.busibase.busi.bo.QryTransFeeReqBO;
import com.tydic.uoc.busibase.busi.bo.QryTransFeeRspBO;
import com.tydic.uoc.busibase.busi.bo.SkuEntity;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pebIntfQryTransportFeeAbilityService")
public class PebIntfQryTransportFeeAbilityServiceImpl
implements PebIntfQryTransportFeeAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryTransportFeeAbilityServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private PebIntfQryTransportFeeBusiService pebIntfQryTransportFeeBusiService;

    public PebIntfQryTransportFeeAbilityServiceImpl(PebIntfQryTransportFeeBusiService pebIntfQryTransportFeeBusiService) {
        this.pebIntfQryTransportFeeBusiService = pebIntfQryTransportFeeBusiService;
    }

    @Override
    public QryTransFeeRspBO queryTransFee(QryTransFeeReqBO qryTransFeeReqBO) {
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2:" + qryTransFeeReqBO.toString());
        }
        this.validateRequestParams(qryTransFeeReqBO);
        return this.pebIntfQryTransportFeeBusiService.queryTransFee(qryTransFeeReqBO);
    }

    private void validateRequestParams(QryTransFeeReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u4f9b\u5e94\u5546\u7f16\u53f7\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SkuEntity> sku = reqBO.getSku();
        if (CollectionUtils.isEmpty(sku)) {
            throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u5546\u54c1\u3010sku\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isNotEmpty(sku)) {
            for (SkuEntity skuEntity : sku) {
                if (skuEntity.getSkuId() == null) {
                    throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u5546\u54c1\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (skuEntity.getNum() != null) continue;
                throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u5546\u54c1\u6570\u91cf\u3010num\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (reqBO.getProvince() == null) {
            throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u4e00\u7ea7\u5730\u5740\u3010province\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCity() == null) {
            throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u4e8c\u7ea7\u5730\u5740\u3010city\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCounty() == null) {
            throw new UocProBusinessException("7777", "\u8fd0\u8d39\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  \u4e09\u7ea7\u5730\u5740\u3010county\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

