/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.ability;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.order.ability.UocProMergeOrderCreateAbilityService;
import com.tydic.order.ability.bo.UocProMergeOrderCreateAbilityServiceReqBo;
import com.tydic.order.ability.bo.UocProMergeOrderCreateAbilityServiceRspBo;
import com.tydic.order.ability.bo.UocProMergeOrderCreateAddressBo;
import com.tydic.order.ability.bo.UocProMergeOrderCreateOrderItemBo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.zone.ability.api.PebExtAgreementCreateOrderAbilityService;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.order.ability.UocProMergeOrderCreateAbilityService"})
public class UocProMergeOrderCreateAbilityServiceImpl
implements UocProMergeOrderCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocProMergeOrderCreateAbilityServiceImpl.class);
    @Autowired
    private PebExtAgreementCreateOrderAbilityService pebExtAgreementCreateOrderAbilityService;
    @Autowired
    private OrderGenerateIdUtil idUtil;

    @PostMapping(value={"createOrder"})
    public UocProMergeOrderCreateAbilityServiceRspBo createOrder(@RequestBody UocProMergeOrderCreateAbilityServiceReqBo reqBo) {
        this.validateArg(reqBo);
        long mergeOrderId = this.idUtil.nextId();
        UocProMergeOrderCreateAbilityServiceRspBo rspBo = (UocProMergeOrderCreateAbilityServiceRspBo)UocProRspBoUtil.success(UocProMergeOrderCreateAbilityServiceRspBo.class);
        List saleOrderItemList = reqBo.getSaleOrderItemList();
        Map<String, List<UocProMergeOrderCreateOrderItemBo>> itemsMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocProMergeOrderCreateOrderItemBo::getOrderSource));
        for (String key : itemsMap.keySet()) {
            if ("1".equals(key)) {
                PebExtAgreementCreateOrderReqBO zoneOrderReq = (PebExtAgreementCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), PebExtAgreementCreateOrderReqBO.class);
                zoneOrderReq.setMergeOrderId(Long.valueOf(mergeOrderId));
                ArrayList<PebExtAgreementSkuInfo> zoneItemList = new ArrayList<PebExtAgreementSkuInfo>(itemsMap.get(key).size());
                for (UocProMergeOrderCreateOrderItemBo itemBo : itemsMap.get(key)) {
                    PebExtAgreementSkuInfo zoneItemBo = (PebExtAgreementSkuInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemBo), PebExtAgreementSkuInfo.class);
                    log.info("zoneItemBo " + zoneItemBo.getTotalPrice());
                    log.info("zoneItemBo " + zoneItemBo.getPreFee());
                    zoneItemList.add(zoneItemBo);
                }
                zoneOrderReq.setSaleOrderItemList(zoneItemList);
                zoneOrderReq.setOrderSource("1");
                PebExtAgreementCreateOrderRspBO zoneOrderRsp = this.pebExtAgreementCreateOrderAbilityService.dealPebExtAgreementCreateOrder(zoneOrderReq);
                log.info("\u534f\u8bae\u4e0b\u5355\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)zoneOrderRsp));
                if (!"0000".equals(zoneOrderRsp.getRespCode())) {
                    UocProMergeOrderCreateAbilityServiceRspBo failedRspBo = (UocProMergeOrderCreateAbilityServiceRspBo)UocProRspBoUtil.failed((String)"214001", (String)zoneOrderRsp.getRespDesc(), UocProMergeOrderCreateAbilityServiceRspBo.class);
                    failedRspBo.setFailedCommodityBoList(zoneOrderRsp.getFailedCommodityBoList());
                    return failedRspBo;
                }
                rspBo.getFailedCommodityBoList().addAll(zoneOrderRsp.getFailedCommodityBoList());
                if (!CollectionUtil.isEmpty((Collection)zoneOrderRsp.getSubmitOrderSaleItem())) {
                    rspBo.getOrderIds().addAll(zoneOrderRsp.getSubmitOrderSaleItem().stream().map(PebExtAgreementSubmitOrderSaleItemRspBO::getOrderId).collect(Collectors.toList()));
                }
                rspBo.setParOrdNo(zoneOrderRsp.getParOrdNo());
                rspBo.setParOrdTime(DateUtil.dateToStrLong((Date)zoneOrderRsp.getParOrdTime()));
                rspBo.setGoodsClassNum(Integer.valueOf(reqBo.getSaleOrderItemList().size()));
                rspBo.setGoodsTotalNum(Integer.valueOf(zoneOrderRsp.getTotalPurchaseCount().intValue()));
                rspBo.setOrdRelateShops(String.join((CharSequence)",", zoneOrderRsp.getShopNameSet()));
                rspBo.setOrdRelateCount(Integer.valueOf(zoneOrderRsp.getShopNameSet().size()));
                rspBo.setParTotalSaleFee(zoneOrderRsp.getParTotalSaleFee().divide(new BigDecimal("10000"), 2, RoundingMode.DOWN));
                continue;
            }
            throw new UocProBusinessException("214001", "\u5b58\u5728\u975e\u4e13\u533a\u4e0b\u5355\u4e1a\u52a1\u4e0b\u5355\u5931\u8d25");
        }
        rspBo.setParOrdId(Long.valueOf(mergeOrderId));
        return rspBo;
    }

    private void validateArg(UocProMergeOrderCreateAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("214001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List saleOrderItemList = reqBo.getSaleOrderItemList();
        if (ObjectUtil.isEmpty((Object)saleOrderItemList)) {
            throw new UocProBusinessException("214001", "[saleOrderItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getTotalAmount()) {
            throw new UocProBusinessException("214001", "\u7ed3\u7b97\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayType()) {
            throw new UocProBusinessException("214001", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPurchaserAccount()) {
            throw new UocProBusinessException("214001", "\u91c7\u8d2d\u8d26\u5957\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getGiveTime())) {
            throw new UocProBusinessException("214001", "\u9001\u8d27\u65f6\u95f4\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new UocProBusinessException("214001", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBudgetInfo() == null) {
            throw new UocProBusinessException("214001", "\u4e0b\u5355\u9884\u7b97\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getBudgetInfo().getBudgetId() == null) {
            throw new UocProBusinessException("214001", "\u4e0b\u5355\u5165\u53c2\u9884\u7b97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUsername())) {
            throw new UocProBusinessException("214001", "\u91c7\u8d2d\u4eba\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgId()) {
            throw new UocProBusinessException("214001", "\u91c7\u8d2d\u4eba\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getCompanyId()) {
            throw new UocProBusinessException("214001", "\u5c5e\u6027[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAddressInfo()) {
            throw new UocProBusinessException("214001", "\u53d1\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateAdrees(reqBo.getAddressInfo(), "\u6536\u8d27\u4eba");
        this.validateAdrees(reqBo.getInvoiceAddressInfo(), "\u53d1\u7968");
        BigDecimal inputRealFee = new BigDecimal(0);
        for (UocProMergeOrderCreateOrderItemBo itemBo : saleOrderItemList) {
            if (itemBo == null) {
                throw new UocProBusinessException("214001", "saleOrderItemList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getOrderSource())) {
                throw new UocProBusinessException("214001", "saleOrderItemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[orderSource]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String orderSource = itemBo.getOrderSource();
            if (!("2".equals(orderSource) || "1".equals(orderSource) || "3".equals(orderSource))) {
                throw new UocProBusinessException("214001", "saleOrderItemList\u4e2d\u5bf9\u8c61\u5c5e\u6027[orderSource[" + orderSource + "]]\u4e0d\u652f\u6301");
            }
            if ("1".equals(orderSource) && ObjectUtil.isEmpty((Object)itemBo.getAgrId())) {
                throw new UocProBusinessException("214001", "\u534f\u8bae\u5546\u54c1\uff0c\u534f\u8baeid(agrId)\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)itemBo.getGoodsSupplierId())) {
                throw new UocProBusinessException("214001", "\u4f9b\u5e94\u5546[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)itemBo.getSkuId())) {
                throw new UocProBusinessException("214001", "skuId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getPurchaseCount()) {
                throw new UocProBusinessException("214001", "\u91c7\u8d2d\u6570\u91cf[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == itemBo.getSkuSalePrice()) {
                throw new UocProBusinessException("214001", "\u9500\u552e\u4ef7\u683c[skuSalePrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSkuName())) {
                throw new UocProBusinessException("214001", "\u5c5e\u6027[skuName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSkuMainPicUrl())) {
                throw new UocProBusinessException("214001", "\u5c5e\u6027[skuMainPicUrl]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSkuSupplierName())) {
                throw new UocProBusinessException("214001", "\u5c5e\u6027[skuSupplierName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getPurchType())) {
                itemBo.setPurchType(PebExtConstant.PurchType.NOT_PLAN);
            }
            if (!ObjectUtil.isEmpty((Object)itemBo.getPlanId())) {
                if (ObjectUtil.isEmpty((Object)itemBo.getPlanItemId())) {
                    throw new UocProBusinessException("214001", "planId,planItemId,planItemNo\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)itemBo.getPlanItemNo())) {
                    throw new UocProBusinessException("214001", "planId,planItemId,planItemNo\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!ObjectUtil.isEmpty((Object)itemBo.getPlanItemId())) {
                if (ObjectUtil.isEmpty((Object)itemBo.getPlanId())) {
                    throw new UocProBusinessException("214001", "planId,planItemId,planItemNo\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)itemBo.getPlanItemNo())) {
                    throw new UocProBusinessException("214001", "planId,planItemId,planItemNo\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!ObjectUtil.isEmpty((Object)itemBo.getPlanId()) && !ObjectUtil.isEmpty((Object)itemBo.getPlanItemId())) {
                itemBo.setPurchType(PebExtConstant.PurchType.PLAN);
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSupplierShopId())) {
                throw new UocProBusinessException("214001", "\u5c5e\u6027[supplierShopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)itemBo.getSpuId())) {
                throw new UocProBusinessException("214001", "\u5c5e\u6027[spuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            inputRealFee = inputRealFee.add(itemBo.getSkuSalePrice().multiply(itemBo.getPurchaseCount()));
        }
        if (inputRealFee.compareTo(reqBo.getTotalAmount()) != 0) {
            throw new UocProBusinessException("214001", "\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u5404\u5546\u54c1\u52a0\u8d77\u6765\u91d1\u989d");
        }
    }

    private void validateAdrees(UocProMergeOrderCreateAddressBo addressInfo, String prefix) {
        if (addressInfo == null) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverProvinceId())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u7701\u4efd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverProvinceName())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u7701\u4efd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCityId())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u57ce\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCityName())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u57ce\u5e02\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCountyId())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverCountyName())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u533a\u53bf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverName())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverMobileNumber())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverEmail())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)addressInfo.getReceiverAddress())) {
            throw new UocProBusinessException("214001", prefix + "\u5730\u5740\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

