/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ifc.expand.einvoice.impl;

import com.alibaba.fastjson.JSON;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.domain.InvoiceResult;
import com.taobao.api.request.AlibabaEinvoiceCreateResultsIncrementGetRequest;
import com.taobao.api.response.AlibabaEinvoiceCreateResultsIncrementGetResponse;
import com.tydic.ifc.expand.einvoice.IfcGetIncrementEinvoiceCreateResultIntfService;
import com.tydic.ifc.expand.einvoice.base.IfcEinvoiceTaoBaoClient;
import com.tydic.ifc.expand.einvoice.bo.IfcEinvoiceIncrementResultBO;
import com.tydic.ifc.expand.einvoice.bo.IfcGetIncrementEinvoiceCreateResultReqBO;
import com.tydic.ifc.expand.einvoice.bo.IfcGetIncrementEinvoiceCreateResultRspBO;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ifcGetIncrementEinvoiceCreateResultService")
public class IfcGetIncrementEinvoiceCreateResultIntfServiceImpl
implements IfcGetIncrementEinvoiceCreateResultIntfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcGetIncrementEinvoiceCreateResultIntfServiceImpl.class);
    private static final Long MAX_PAGE_SIZE = 200L;

    public IfcGetIncrementEinvoiceCreateResultRspBO getIncrementEinvoiceCreateResult(IfcGetIncrementEinvoiceCreateResultReqBO reqBo) {
        AlibabaEinvoiceCreateResultsIncrementGetResponse rsp;
        LOGGER.debug("\u83b7\u53d6\u589e\u91cf\u5f00\u7968\u7ed3\u679c\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        IfcGetIncrementEinvoiceCreateResultRspBO rspBo = new IfcGetIncrementEinvoiceCreateResultRspBO();
        String validateArgStr = this.validateArg(reqBo);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBo.setInvoiceResultList(new ArrayList());
            rspBo.setTotalCount(Long.valueOf(0L));
            rspBo.setCode("7777");
            rspBo.setMsg(validateArgStr);
            rspBo.setSubCode("7777");
            rspBo.setSubMsg(validateArgStr);
            return rspBo;
        }
        DefaultTaobaoClient client = IfcEinvoiceTaoBaoClient.getInstance();
        String sessionKey = IfcEinvoiceTaoBaoClient.getSessionKey();
        AlibabaEinvoiceCreateResultsIncrementGetRequest req = this.buildReqParams(reqBo);
        LOGGER.debug("\u7ec4\u88c5\u540e\u8c03\u7528taobao\u589e\u91cf\u5f00\u7968\u7ed3\u679c\u83b7\u53d6\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        try {
            rsp = (AlibabaEinvoiceCreateResultsIncrementGetResponse)client.execute((TaobaoRequest)req, sessionKey);
            LOGGER.debug("\u8c03\u7528taobao\u589e\u91cf\u5f00\u7968\u7ed3\u679c\u83b7\u53d6\u670d\u52a1\u54cd\u5e94\u51fa\u53c2\uff1a{}", (Object)rsp.getBody());
        }
        catch (ApiException e) {
            rspBo.setInvoiceResultList(new ArrayList());
            rspBo.setTotalCount(Long.valueOf(0L));
            rspBo.setCode(e.getErrCode());
            rspBo.setMsg(e.getErrMsg());
            rspBo.setSubCode(e.getSubErrCode());
            rspBo.setSubMsg(e.getSubErrMsg());
            return rspBo;
        }
        return this.buildRspParams(rspBo, rsp);
    }

    private IfcGetIncrementEinvoiceCreateResultRspBO buildRspParams(IfcGetIncrementEinvoiceCreateResultRspBO rspBo, AlibabaEinvoiceCreateResultsIncrementGetResponse rsp) {
        ArrayList<IfcEinvoiceIncrementResultBO> einvoiceIncrementResult = new ArrayList<IfcEinvoiceIncrementResultBO>();
        if (null != rsp && !CollectionUtils.isEmpty((Collection)rsp.getInvoiceResultList())) {
            for (InvoiceResult invoiceResult : rsp.getInvoiceResultList()) {
                IfcEinvoiceIncrementResultBO incrementResult = new IfcEinvoiceIncrementResultBO();
                incrementResult.setAntiFakeCode(invoiceResult.getAntiFakeCode());
                incrementResult.setBizErrorCode(invoiceResult.getBizErrorCode());
                incrementResult.setBizErrorMsg(invoiceResult.getBizErrorMsg());
                incrementResult.setCiphertext(invoiceResult.getCiphertext());
                incrementResult.setDeviceNo(invoiceResult.getDeviceNo());
                incrementResult.setErpTid(invoiceResult.getErpTid());
                incrementResult.setFileDataType(invoiceResult.getFileDataType());
                incrementResult.setFilePath(invoiceResult.getFilePath());
                incrementResult.setInvoiceAmount(invoiceResult.getInvoiceAmount());
                incrementResult.setInvoiceCode(invoiceResult.getInvoiceCode());
                incrementResult.setInvoiceDate(invoiceResult.getInvoiceDate());
                incrementResult.setInvoiceItems(invoiceResult.getInvoiceItems());
                incrementResult.setInvoiceNo(invoiceResult.getInvoiceNo());
                incrementResult.setInvoiceType(invoiceResult.getInvoiceType());
                incrementResult.setPayeeName(invoiceResult.getPayeeName());
                incrementResult.setPayeePhone(invoiceResult.getPayeePhone());
                incrementResult.setPayeeRegisterNo(invoiceResult.getPayeeRegisterNo());
                incrementResult.setPayerName(invoiceResult.getPayerName());
                incrementResult.setPlatformCode(invoiceResult.getPlatformCode());
                incrementResult.setPlatformTid(invoiceResult.getPlatformTid());
                incrementResult.setQrCode(invoiceResult.getQrCode());
                incrementResult.setSerialNo(invoiceResult.getSerialNo());
                incrementResult.setStatus(invoiceResult.getStatus());
                einvoiceIncrementResult.add(incrementResult);
            }
            rspBo.setTotalCount(rsp.getTotalCount());
        } else {
            rspBo.setTotalCount(Long.valueOf(0L));
        }
        rspBo.setInvoiceResultList(einvoiceIncrementResult);
        return rspBo;
    }

    private AlibabaEinvoiceCreateResultsIncrementGetRequest buildReqParams(IfcGetIncrementEinvoiceCreateResultReqBO reqBo) {
        AlibabaEinvoiceCreateResultsIncrementGetRequest req = new AlibabaEinvoiceCreateResultsIncrementGetRequest();
        req.setEndModified(reqBo.getEndModified());
        req.setPageNo(reqBo.getPageNo());
        req.setPageSize(reqBo.getPageSize());
        req.setPayeeRegisterNo(reqBo.getPayeeRegisterNo());
        req.setStartModified(reqBo.getStartModified());
        req.setStatus(reqBo.getStatus());
        return req;
    }

    private String validateArg(IfcGetIncrementEinvoiceCreateResultReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61[reqBo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.hasText((String)reqBo.getPayeeRegisterNo())) {
            return "\u6536\u6b3e\u65b9\u7a0e\u52a1\u767b\u8bb0\u8bc1\u53f7[payeeRegisterNo]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getStartModified()) {
            return "\u8d77\u59cb\u67e5\u8be2\u65f6\u95f4[startModified]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getEndModified()) {
            return "\u7ec8\u6b62\u67e5\u8be2\u65f6\u95f4[endModified]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null != reqBo.getPageNo() && reqBo.getPageNo() < 1L) {
            reqBo.setPageNo(Long.valueOf(1L));
        }
        if (null != reqBo.getPageSize()) {
            if (reqBo.getPageSize() < 1L) {
                reqBo.setPageSize(Long.valueOf(10L));
            }
            if (reqBo.getPageSize() > MAX_PAGE_SIZE) {
                reqBo.setPageSize(Long.valueOf(200L));
            }
        }
        return null;
    }
}

