/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ifc.expand.utils.top;

import com.tydic.ifc.expand.utils.common.CommonUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TaoBaoSignUtil {
    public static final String SIGN_METHOD_MD5 = "md5";
    public static final String SIGN_METHOD_HMAC = "hmac";

    public static String signTopRequest(Map<String, String> params, String secret, String signMethod) throws IOException {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if (SIGN_METHOD_MD5.equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (!CommonUtils.isNotEmpty((String)key) || !CommonUtils.isNotEmpty(value)) continue;
            query.append((String)key).append(value);
        }
        if (SIGN_METHOD_HMAC.equals(signMethod)) {
            bytes = TaoBaoSignUtil.encryptHmac(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = TaoBaoSignUtil.encryptMd5(query.toString());
        }
        return TaoBaoSignUtil.byte2hex(bytes);
    }

    private static byte[] encryptHmac(String data, String secret) throws IOException {
        byte[] bytes;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static byte[] encryptMd5(String data) throws IOException {
        return TaoBaoSignUtil.encryptMd5(data.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] encryptMd5(byte[] data) throws IOException {
        byte[] bytes;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

