package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName DycActOrderInfoBO
 * @Author 14051
 * @Date 2024/4/2 10:34
 * @Version 1.0
 * @Description 订单列表查询返回对象
 **/
@Data
public class DycActOrderInfoBO implements Serializable {
    private static final long serialVersionUID = 3025472639602428609L;
    /**
     * 订单编号
     */
    private String orderId;
    /**
     * 订单状态
     */
    private Integer orderState;
    /**
     * 订单状态翻译
     */
    private String orderStateStr;
    /**
     * 订单金额
     */
    private BigDecimal orderMoney;
    /**
     * 积分支付金额
     */
    private BigDecimal orderScore;
    /**
     * 个人支付金额
     */
    private BigDecimal personMoney;
    /**
     * 下单时间
     */
    private Date createTime;
    /**
     * 下单人
     */
    private String createUserName;
    /**
     * 下单人账号
     */
    private String createUserAccount;
    /**
     * 订单详情跳转url
     */
    private String detailUrl;
    /**
     * 订单明细对象，返回一条
     */
    private List<DycActOrderItemBO> orderItemInfo;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动适用范围名称
     */
    private String activityScopeOrgName;
    /**
     * 预警类型
     */
    private Integer alertType;
    /**
     * 拉取时间
     */
    private Date receiveTime;
    /**
     * 更新时间
     */
    private Date updateTime;
}
