package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ActivityUserScoresUseRecordPO
 * @Description: ActivityUserScoresUseRecordPO
 * @author: zhoulu
 * @date: 2023年12月11日16:43:58
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityUserScoresUseRecordInfoBO implements Serializable {


	private static final long serialVersionUID = 4319643546708698245L;
	/**
	 * 流水id
	 */
    private Long recordId;
	/**
	 * 活动id
	 */
    private Long activityId;
	/**
	 * 活动名称
	 */
    private String activityName;
	/**
	 * 用户id
	 */
    private Long actUserId;
	/**
	 * 用户名
	 */
    private String actUserName;
	/**
	 * 用户姓名
	 */
    private String actName;
	/**
	 * 使用类型：
            1：发放，2：消费:3：退回，4：失效:
	 */
    private String useType;
    /**
	 * 使用类型翻译：
            1：发放，2：消费:3：退回，4：失效:
	 */
    private String useTypeStr;
	/**
	 * 业务单据类型：1：订单
	 */
    private Integer objType;
	/**
	 * 业务单据ID
	 */
    private Long objId;
	/**
	 * 使用前积分
	 */
    private BigDecimal beforeUseScores;
	/**
	 * 使用积分
	 */
    private BigDecimal useScores;
	/**
	 * 使用后积分
	 */
    private BigDecimal afterUseScores;
	/**
	 * 使用时间
	 */
    private Date useTime;
	/**
	 * 使用人ID
	 */
    private Long useUserId;
	/**
	 * 使用人姓名
	 */
    private String useUserName;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;

}