package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：DycActActivitySyncRecordInfoBO
 * 说明：
 * 时间： 2024-04-17 20:01
 * 作者 @author LY
 */
@Data
public class DycActActivitySyncRecordInfoBO implements Serializable {

    private static final long serialVersionUID = -5027377174730608909L;
    /**
     * ID
     */
    private Long id;
    /**
     * 业务单据id
     */
    private Long objId;
    /**
     * 业务单据类型:
     1:活动；
     2：活动变更
     */
    private Integer objType;
    /**
     * 同步顺序
     */
    private Integer syncOrder;
    /**
     * 同步步骤:
     SYNC_BASE_INFO:同步基本信息
     SYNC_COMMODITY:同步商品信息
     SYNC_USER:同步用户信息
     SYNC_SCORES:同步积分信息
     */
    private String syncStep;

    private String syncStepStr;
    /**
     * 同步结果:
     PENDING:待同步
     UNDERWAY:同步中
     SUCCESS:同步成功
     FAIL:同步失败
     */
    private String syncResult;

    private String syncResultStr;
    /**
     * 同步完成时间
     */
    private Date syncFinishTime;
    /**
     * 错误信息
     */
    private String errorInfo;
}
