package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName DycActFscOrderInfoBO
 * @Author 14051
 * @Date 2024/4/3 15:58
 * @Version 1.0
 * @Description TODO
 **/
@Data
public class DycActFscOrderInfoBO implements Serializable {
    private static final long serialVersionUID = 5639891391545969834L;
    /**
     * 结算单ID
     */
    private Long fscOrderId;
    /**
     * 结算单编号
     */
    private String orderNo;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 结算单状态
     */
    private Integer orderState;
    /**
     * 结算单状态翻译
     */
    private String orderStateStr;
    /**
     * 供应商ID
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 创建人
     */
    private String createOperName;
    /**
     * 结算单金额
     */
    private BigDecimal totalCharge;
    /**
     * 发票总金额
     */
    private BigDecimal invoiceCharge;
    /**
     * 最后付款时间
     */
    private Date lastPayTime;
    /**
     * 运营最后付款时间
     */
    private Date yyLastPayTime;
    /**
     * 结算单创建时间
     */
    private Date createTime;
    /**
     * 开票时间
     */
    private Date billTime;
    /**
     * 签收时间
     */
    private Date signTime;
    /**
     * 付款确认时间
     */
    private Date payTime;
    /**
     * 物流公司
     */
    private String logisticsCompany;
    /**
     * 发票邮寄单号
     */
    private String logisticsOrder;
    /**
     * 邮寄详情
     */
    private String mailDesc;
    /**
     * 预警类型
     */
    private Integer alertType;

    /**
     * 创建人用户ID
     */
    private Long createUserId;

    /**
     * 付款方ID
     */
    private Long payerId;
    /**
     * 付款方名称
     */
    private String payerName;

    /**
     * 收款方ID
     */
    private Long payeeId;
    /**
     * 收款方名称
     */
    private String payeeName;


    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 附件
     */
    private List<DycActActiveFileInfoBO> attachmentList;
    /**
     * 对账单附件
     */
    private List<DycActActiveFileInfoBO> billAttList;
}
