package com.tydic.dyc.act.service.bo;

import com.tydic.dyc.base.bo.DycCenterPageReqBaseBO;
import lombok.Data;

import java.util.Date;

/**
 * 标题：DycActActiveListQueryReqBO
 * 说明：活动列表查询BO
 * 时间： 2023-12-12 11:13
 * 作者 @author LY
 */
@Data
public class DycActQueryActivityPageListReqBO extends DycCenterPageReqBaseBO {
    private static final long serialVersionUID = -1878239845289143714L;

    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动场景id
     */
    private Long activitySceneId;
    /**
     * 活动类型:1:工会活动；2：公司活动
     */
    private Integer activityType;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 	活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    private String activityState;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 创建开始时间
     */
    private Date createStartTime;
    /**
     * 创建结束时间
     */
    private Date createEndTime;
    /**
     * 页签id：
     * 1001：待生效
     * 1002：生效中
     * 1003：已失效
     * 1004：全部
     */
    private String tabId;
    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Long commodityRelaMethod;
    /**
     * 最后付款日期
     */
    private Date lastPayTime;
    /**
     * 最后付款日期
     */
    private Date lastPayTimeStart;
    /**
     * 最后付款日期
     */
    private Date lastPayTimeEnd;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTime;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTimeStart;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTimeEnd;
    /**
     * 等于1就查询
     */
    private Integer flagQry;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 是否结算:
     0:未结算；
     1：已结算
     */
    private Integer isSettleFlag;
    /**
     * 是否查询供应商信息：等于1就查询
     */
    private Integer supplierFlag;

    private Long createUserId;
    private Long createOrgId;
    private Long createCompanyId;
    private String createOrgTreePath;

    /**
     * 活动同步状态:
     * 1:待同步
     * 2：同步中
     * 3：同步成功
     * 4：同步失败
     */
    private Integer activitySyncState;
    /**
     * 排序字段
     */
    private String orderBy;

    /**
     * 预警类型
     */
    private Integer alertType;
}
