package com.tydic.dyc.act.service.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 类名： DycActQuerySkuListReqBO
 * 说明：商品列表查询服务--入参
 *
 * @author： lishiqing
 * 时间： 2024/4/8 16:19
 */
@Data
public class DycActQuerySkuListReqBO implements Serializable {
    private static final long serialVersionUID = 7102748410012322637L;
    /**
     * 外部单品id
     */
    private String extSkuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 单品名称
     */
    private String skuCode;
    /**
     * 商品类目ID
     */
    private Long guideCatalogId;
    /**
     * 商品类目等级
     */
    private Integer catalogLevel;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private List<Integer> skuStatusList;
    /**
     * 协议价最小值
     */
    private BigDecimal agreementPriceMin;
    /**
     * 协议价最大值
     */
    private BigDecimal agreementPriceMax;
    /**
     * 市场价最小值
     */
    private BigDecimal marketPriceMin;
    /**
     * 市场价最大值
     */
    private BigDecimal marketPriceMax;
    /**
     * 折扣率最小值
     */
    private BigDecimal discountMin;
    /**
     * 折扣率最大值
     */
    private BigDecimal discountMax;
    /**
     * 商品池ID
     */
    private Long poolId;
    /**
     * 排除单品活动ID
     */
    private Long exitsActivityId;
    /**
     * 排除单品变更ID
     */
    private Long exitsChangeId;
    /**
     * 排除商品池ID
     */
    private Long exitsPoolId;
    /**
     * 供应商ID
     */
    private Long supplierId;
    /**
     * 单品ID集合
     */
    private List<Long> skuIds;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 是否查询停用类目商品
     */
    private Boolean qryDisableCatalog;
    /**
     * 价格是否异常：0异常1正常
     */
    private Integer isAnomalousPrice;
    /**
     * 69码集合
     */
    private List<String> upcList;
    /**
     * 排除单品ID集合
     */
    private List<Long> exitsSkuIds;
}
