package com.tydic.dyc.act.constants;

/**
 * 标题:ActConstants
 * 说明:常量类
 * 时间:2021/4/19 下午4:23
 * 作者:罗有
 */

public class ActConstants {
	/**
	 * 删除标志
	 0:未删除 1：已删除
	 */
	public static final class DelFlag {
		/**
		 * 0:未删除
		 */
		public static final Integer NOT_DEL = 0;
		/**
		 * 1：已删除
		 */
		public static final Integer DEL = 1;
	}

	/**
	 * 业务对象类型:
	 1：活动
	 2：活动变更单
	 3：审批单
	 4：结算单
	 */
	public static final class ObjType {
		/**
		 *  1：活动
		 */
		public static final Integer ACT = 1;
		/**
		 *  2：活动变更单
		 */
		public static final Integer ACT_CHANGE = 2;
		/**
		 *  3：审批单
		 */
		public static final Integer APPROVAL = 3;
		/**
		 *  4：结算单
		 */
		public static final Integer FSC = 4;
	}

	/**
	 * 活动状态:1:草稿；2：待审批；3：已驳回；4：未生效；5：已生效；6：已关闭；7：已失效；8：变更中
	 */
	public static final class ActivityState {
		/**
		 * 1:草稿
		 */
		public static final String  DRAFT = "1";
		/**
		 * 2：待审批
		 */
		public static final String NOT_APPROVAL = "2";
		/**
		 * 3：已驳回
		 */
		public static final String REJECTED = "3";
		/**
		 * 4：未生效
		 */
		public static final String NO_ACTIVE = "4";
		/**
		 * 5：已生效
		 */
		public static final String ACTIVE = "5";
		/**
		 * 6：已关闭
		 */
		public static final String CLOSE = "6";
		/**
		 * 7：已失效
		 */
		public static final String FAILURE = "7";
		/**
		 * 8：变更中
		 */
		public static final String CHANGEING = "8";
	}

	/**
	 * 变更类型:1:新增；2：修改；3：删除
	 */
	public static final class ChangeType {
		/**
		 *  1:新增
		 */
		public static final Integer ADD = 1;
		/**
		 *  2：修改
		 */
		public static final Integer UPDATE = 2;
		/**
		 *  3：删除
		 */
		public static final Integer DEL = 3;
	}

	/**
	 * 变更单状态:1:待审批；2：审批通过；3：已驳回
	 */
	public static final class ChangeState {
		/**
		 *  1:待审批
		 */
		public static final String  WAIT = "1";
		/**
		 *  2：审批通过
		 */
		public static final String PASS = "2";
		/**
		 *  3：已驳回
		 */
		public static final String FAIL = "3";
	}

	/**
	 * 活动同步状态:
	 * 1:待同步
	 * 2：同步中
	 * 3：同步成功
	 * 4：同步失败
	 */
	public static final class SyncState {
		/**
		 *  1:待同步
		 */
		public static final Integer  WAIT = 1;
		/**
		 *  2：同步中
		 */
		public static final Integer SYNCING = 2;
		/**
		 * 3：同步成功
		 */
		public static final Integer SUCCESS = 3;
		/**
		 * 4：同步失败
		 */
		public static final Integer FAIL = 4;
	}
}