package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * @ClassName DycActFscInvoiceModel
 * @Author 14051
 * @Date 2024/4/3 11:25
 * @Version 1.0
 * @Description 结算单发票接口类
 **/
public interface DycActFscInvoiceModel {
    /**
     * 查询发票明细列表
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActFscInvoiceItemInfo> qryInvoiceItemList(DycActFscInvoiceDO reqBO);

    /**
     * 查询单条发票信息
     * @param reqBO
     * @return
     */
    DycActFscInvoiceInfo getInvoiceInfoByInvoiceNo(DycActFscInvoiceDO reqBO);

    /**
     * 查询发票列表
     * @param reqBO
     * @return
     */
    public BasePageRspBo<DycActFscInvoiceInfo> qryInvoiceList(DycActFscInvoiceDO reqBO);

    /**
     * g根据结算单ID批量查询发票总金额
     * @param reqBO
     * @return
     */
    List<DycActFscInvoiceAmt> getInvoiceAmtByFscOrderIds(DycActFscInvoiceAmtDO reqBO);

    /**
     * 查询发票开票信息以及总金额等
     * @param reqBO
     * @return
     */
    DycActFscInvoiceInfo getSumAmtByFscOrderId(DycActFscInvoiceDO reqBO);

    /**
     * 批量保存发票信息
     * @param reqBO
     * @return
     */
    void saveFscInvoices(DycActFscInvoiceDO reqBO);

    /**
     * 保存发票明细数据
     * @param reqBO
     */
    void saveFscInvoiceItem(DycActFscInvoiceItemDO reqBO);

    /**
     * 更新发票表中的是否获取发票明细标识
     * @param reqBO
     */
    int updateFscInvoiceFlag(DycActFscInvoiceItemDO reqBO);

    /**
     * 获取结算单发票未获取发票明细的数量
     * @param reqBO
     * @return
     */
    int getCountUnGetItem(DycActFscInvoiceItemDO reqBO);
}
