package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName DycActFscOrderModel
 * @Author 14051
 * @Date 2024/4/2 20:23
 * @Version 1.0
 * @Description TODO
 **/
public interface DycActFscOrderModel {
    /**
     * 确认付款操作
     * @param reqBO
     * @return
     */
    int dealPayOrderState(DycActFscOrderDO reqBO);

    /**
     * 签收操作
     * @param reqBO
     * @return
     */
    int dealSignOrderState(DycActFscOrderSignDO reqBO);

    /**
     * 查询单个
     * @param reqBO
     * @return
     */
    DycActFscOrderInfo getFscOrderOne(DycActFscOrderDO reqBO);

    /**
     * 结算单列表查询(分页)
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActFscOrderInfo> selectByCondition(DycActFscOrderQryDO reqBO);

    /**
     * 结算单列表查询（不分页）
     * @param qryDo
     * @return
     */
    List<DycActFscOrderInfo> queryFscOrderList(DycActFscOrderQryDO qryDo);

    /**
     * 批量查询结算单附件
     * @param reqBO
     * @return
     */
    List<DycActFscOrderFileInfo> selectFileListByIds(DycActFscOrderFileQryDO reqBO);

    /**
     * 查询结算单订单数量
     * @param reqBO
     * @return
     */
    int getFscOrderNum(DycActFscOrderDO reqBO);

    /**
     * 查询发票信息
     * @param reqBO
     * @return
     */
    DycActFscOrderInvoiceInfo selectOneFscOrderInvoice(DycActFscOrderDO reqBO);

    /**
     * 查询对账数据列表
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActFscRelOrderInfo> selectRelOrderByConditon(DycActFscRelOrderDO reqBO);

    /**
     * 驳回操作
     * @param reqBO
     * @return
     */
    int dealFscOrderReject(DycActFscOrderDO reqBO);

    /**
     * 更新物流信息
     * @param reqBO
     * @return
     */
    int updateFscOrderLogisticsInfo(DycActFscOrderLogisticsInfoDO reqBO);

    /**
     * 处理结算单状态操作
     * @param reqBO
     * @return
     */
    int dealFscOrderState(DycActFscOrderDO reqBO);

    /**
     * 处理结算单关联订单关系
     * @param reqBO
     */
    void dealFscOrdRelationCancel(DycActFscOrderDO reqBO);

    /**
     * 保存结算单主单信息
     * @param reqBO
     * @return
     */
    DycActFscOrdSaveInfo saveFscOrder(DycActFscOrderSaveDO reqBO);

    /**
     * 分页查询订单结算关系表
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActFscOrderRelationInfo> getFscOrderRelationList(DycActFscOrderQryDO reqBO);

    /**
     * 更新批次号
     * @param reqBO
     * @return
     */
    int updateRelationBatch(DycActFscOrderRelationDO reqBO);

    /**
     * 保存批次信息
     * @param reqBO
     * @return
     */
    int saveBatchInfo(DycActFscOrderBatchInfoDO reqBO);

    /**
     * 更新推送结果
     * @param reqBO
     * @return
     */
    int updateBatchInfo(DycActFscOrderBatchInfoDO reqBO);

    /**
     * 根据批次号和结算单ID查询当前批次的订单ID
     * @param reqBO
     * @return
     */
    List<DycActFscOrderRelationInfo> getFscOrdRelationList(DycActFscOrderBatchInfoDO reqBO);

    /**
     * 查询当前批次金额
     * @param reqBO
     * @return
     */
    BigDecimal getCurrentAmt(DycActFscOrderBatchInfoDO reqBO);

    /**
     * 查询当前结算单是否全部推送电商成功
     * @param reqBO
     * @return
     */
    int getFscPushFailNum(DycActFscOrderDO reqBO);

    /**
     * 取消结算单删除批次明细表
     * @param reqBO
     * @return
     */
    int deleteFscOrderBatchInfo(DycActFscOrderDO reqBO);
    /**
     * 查询满足预警未签收的结算单
     * @param reqBO
     * @return
     */
    List<Long> qryAlertFscOrderList(DycActDealAlertQryOrderDO reqBO);
    /**
     * 处理结算单预警保存等
     * @param dycActDealOrderAlertDO
     */
    void dealFscOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO);

    /**
     * 更新预警状态
     * @param reqBO
     */
    void dealUpdFscOrdAlertType(DycActFscOrderDO reqBO);

    /**
     * 获取预警结算单
     * @param qryDO
     * @return
     */
    List<DycActFscOrderDO> getFscOrderWarning(DycActFscOrderQryDO qryDO);

}
