package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActLaborUnionInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 标题：DycActIaborModel
 * 说明：
 * 时间： 2024-03-26 15:45
 * 作者 @author LY
 */
public interface DycActIaborModel {

    /**
     * 描述:工会新增服务
     *
     * @param reqBO
     * @return int
     */
    int addLaborUnion(DycActIaborDO reqBO);
    /**
     * 描述:工会修改服务
     *
     * @param reqBO
     * @return int
     */
    int modifyLaborUnion(DycActIaborDO reqBO);
    /**
     * 描述:工会删除服务
     *
     * @param reqBO
     * @return int
     */
    int deleteLaborUnion(DycActIaborDO reqBO);
    /**
     * 描述:工会列表查询（分页）服务
     *
     * @param reqBO
     * @return int
     */
    BasePageRspBo<DycActLaborUnionInfo> queryLaborUnionPageList(DycActIaborDO reqBO);
    /**
     * 描述:工会详情查询服务
     *
     * @param reqBO
     * @return int
     */
    DycActLaborUnionInfo queryLaborUnionDetails(DycActIaborDO reqBO);
    /**
     * 描述:机构所属工会下拉框查询服务
     *
     * @param reqBO
     * @return int
     */
    List<DycActLaborUnionInfo> queryOrgBelongLaborUnion(DycActIaborDO reqBO);
}
