package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName DycActOrderModel
 * @Author 14051
 * @Date 2024/4/2 10:47
 * @Version 1.0
 * @Description TODO
 **/
public interface DycActOrderModel {
    /**
     * 订单列表查询
     * @param dycActOrderQryDO
     * @return
     */
    BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO);

    /**
     * 订单服务单列表查询
     * @param dycActOrderAfsQryDO
     * @return
     */
    BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO);

    /**
     * 查询某个活动的总积分
     * @param activityId
     * @return
     */
    BigDecimal getTotalScoreByActivityId(Long activityId);

    /**
     * 查询满足预警的订单
     * @param reqBO
     * @return
     */
    List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO);

    /**
     * 处理订单预警保存等
     * @param dycActDealOrderAlertDO
     */
    void dealOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO);

    /**
     * 存在预警订单
     * @param dycActDealAlertQryOrderDO
     * @return
     */
    List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);

    /**
     * 更新订单预警状态
     * @param dycActDealOrderAlertDO
     */
    void dealUpdOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO);
    /**
     * 查询满足预警的服务单
     * @param reqBO
     * @return
     */
    List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO);
    /**
     * 处理服务单预警保存等
     * @param dycActDealOrderAlertDO
     */
    void dealAfsOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO);
    /**
     * 存在预警订单服务单
     * @param dycActDealAlertQryOrderDO
     * @return
     */
    List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);
    /**
     * 更新服务单预警状态
     * @param dycActDealOrderAlertDO
     */
    void dealUpdAfsOrderAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO);

    /**
     * 预警订单列表获取
     * @return
     */
    List<DycActOrderInfo> getWarnIngOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO);

    /**
     * 预警售后单列表获取
     * @param qryDO
     * @return
     */
    List<ActOrderAfterInfo> getOrderAfterWaring(DycActOrderAfsQryDO qryDO);

    /**
     * 判断是否有未完成的订单
     * @param reqBO
     * @return
     */
    String getUnFinishOrderId(DycActOrderQryDO reqBO);

    DycActOrderInfo queryOrderDetail(DycActOrderQryDO qryDO);

    List<ActOrderItemInfoDO> qryOrderItemInfoList(DycActOrderQryDO qryDO);

    ActOrderConsigneeInfoBO qryOrderConsignee(DycActOrderQryDO qryDO);
}
