package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.DycActActivityApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActActivityChangeApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityFlowInstanceInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.base.bo.BasePageRspBo;

/**
 * 描述: 〈流程子域相关方法〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:17
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActProcessModel {
    /**
     * 活动审批列表查询（分页）服务
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO);

    /**
     * 活动变更审批列表查询（分页）服务
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO);


    DycActivityFlowInstanceInfo dealTaskDeal(DycProcessDO reqBO);

    DycActivityFlowInstanceInfo dealTaskFinish(DycProcessDO reqBO);

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: activityFlowInstanceReqBO
     * @return: ActivityFlowInstanceRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    DycActivityFlowInstanceInfo queryActivityFlowInstanceSingleTime(DycProcessDO reqBO);

    /**
     * 描述:新增多条信息
     *
     * @throws
     * @param: activityFlowInstanceReqBO
     * @return: ActivityFlowInstanceRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    Long addActivityFlowInstance(DycProcessDO reqBO);

    /**
     * 描述:查询信息（单个）
     *
     * @throws
     * @param: activityFlowInstanceReqBO
     * @return: ActivityFlowInstanceRspBO
     * @author: zhoulu
     * @date: 2023-12-19 15:49:50
     */
    DycActivityFlowInstanceInfo queryActivityFlowInstanceSingle(DycProcessDO reqBO);
}
