package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: ActActivitySyncExternalRecordPO
 * @Description: ActActivitySyncExternalRecordPO
 * @author: liaoyang
 * @date: 2024年04月09日20:05:50
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActActivitySyncExternalRecordInfo implements Serializable {
	private static final long serialVersionUID = 6350163416988466446L;
	/**
	 * ID
	 */
    private Long id;
	/**
	 * 业务单据id
	 */
    private Long objId;
	/**
	 * 业务单据类型:
            1:活动；
            2：活动变更
	 */
    private Integer objType;
	/**
	 * 同步顺序
	 */
    private Integer syncOrder;
	/**
	 * 同步步骤:
            SYNC_BASE_INFO:同步基本信息
            SYNC_COMMODITY:同步商品信息
            SYNC_USER:同步用户信息
            SYNC_SCORES:同步积分信息
	 */
    private String syncStep;

	private String syncStepStr;
	/**
	 * 同步结果:
            PENDING:待同步
            UNDERWAY:同步中
            SUCCESS:同步成功
            FAIL:同步失败
	 */
    private String syncResult;
	private String syncResultStr;
	/**
	 * 同步完成时间
	 */
    private Date syncFinishTime;
	/**
	 * 错误信息
	 */
    private String errorInfo;

}