package com.tydic.dyc.act.model.bo;

import com.ohaotian.plugin.base.bo.ReqPage;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActSkuGuide入参
 * @Description: ActSkuGuide入参
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActSkuGuideReqBO extends ReqPage implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 类目ID
	 */
    private Long guideCatalogId;
	/**
	 * 类目编码
	 */
    private String catalogCode;
	/**
	 * 类目名称
	 */
    private String catalogName;
	/**
	 * 上级类目id
	 */
    private Long upperCatalogId;
	/**
	 * 排序
	 */
    private Integer viewOrder;
	/**
	 * 状态： 0:停用 1:启用
	 */
    private Integer catalogStatus;
	/**
	 * 类目等级
	 */
    private Integer catalogLevel;
	/**
	 * 创建人
	 */
    private String createOperName;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 修改人
	 */
    private String updateOperName;
	/**
	 * 修改时间
	 */
    private Date updateTime;
	/**
	 * 类目ID
	 */
	private List<Long> guideCatalogIdList;

	/**
	 * 插入方式：
	 * <p>
	 * 0 在目标之前
	 * <p>
	 * 1 与目标互换
	 */
	private Integer orderConfSolution = 0;
}