package com.tydic.dyc.act.model.bo;

import com.tydic.dyc.base.bo.DycCenterPageReqBaseBO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 类名： DycActQuerySkuPageListReqBO
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/8 16:19
 */
@Data
public class ActSkuInfoQryBO extends DycCenterPageReqBaseBO {
    private static final long serialVersionUID = 5231124381082335926L;
    /**
     * 外部单品id
     */
    private String extSkuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private List<Integer> skuStatusList;
    /**
     * 协议价最小值
     */
    private BigDecimal agreementPriceMin;
    /**
     * 协议价最大值
     */
    private BigDecimal agreementPriceMax;
    /**
     * 市场价最小值
     */
    private BigDecimal marketPriceMin;
    /**
     * 市场价最大值
     */
    private BigDecimal marketPriceMax;
    /**
     * 折扣率最小值
     */
    private BigDecimal discountMin;
    /**
     * 折扣率最大值
     */
    private BigDecimal discountMax;
    /**
     * 商品池ID
     */
    private Long poolId;
    /**
     * 排除商品池ID
     */
    private Long exitsPoolId;
    /**
     * 单品id
     */
    private Long skuId;
    /**
     * 单品编号
     */
    private String skuCode;
    /**
     * 京东C端链接
     */
    private String jdSkuUrl;
    /**
     * 单品状态：1：已上架 2：已下架 0 ：已删除
     */
    private Integer skuStatus;
    /**
     * 三级类目id

     */
    private Long guideId;
    /**
     * 品牌名称
     */
    private String brandName;
    /**
     * 来源电商id
     */
    private Long supplierId;
    /**
     * 来源电商名称
     */
    private String supplierName;
    /**
     * 市场价
     */
    private BigDecimal marketPrice;
    /**
     * 协议价
     */
    private BigDecimal agreementPrice;
    /**
     * 折扣率
     */
    private BigDecimal discount;
    /**
     * 最小起订量
     */
    private Integer moq;
    /**
     * 销售单位
     */
    private String measureName;
    /**
     * 好评率
     */
    private BigDecimal goodRate;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 单品ID集合
     */
    private List<Long> skuIds;
    /**
     * 排除单品ID集合
     */
    private List<Long> exitsSkuIds;
    /**
     * 商品类目集合
     */
    private List<Long> guideIdList;
    /**
     * 商品类目集合
     */
    private List<Long> poolGuideIdList;
    /**
     * 排除商品类目集合
     */
    private List<Long> exitsGuideIdList;
    /**
     * 排除商品类目集合
     */
    private List<Long> exitsPoolGuideIdList;
    /**
     * 供应商集合
     */
    private List<Long> supplierIdList;
    /**
     * 排除供应商集合
     */
    private List<Long> exitsSupplierIdList;
    /**
     * 供应商集合
     */
    private List<Long> poolSupplierIdList;
    /**
     * 排除供应商集合
     */
    private List<Long> exitsPoolSupplierIdList;
    /**
     * 是否查询停用类目商品
     */
    private Boolean qryDisableCatalog;


}
