package com.tydic.dyc.act.model.bo;

import com.ohaotian.plugin.base.bo.ReqPage;

import lombok.Data;
import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActSkuInfo入参
 * @Description: ActSkuInfo入参
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActSkuInfoReqBO extends ReqPage implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 单品id
	 */
    private Long skuId;
	/**
	 * 单品名称
	 */
    private String skuName;
	/**
	 * 外部单品id
	 */
    private String extSkuId;
	/**
	 * 单品编号
	 */
    private String skuCode;
	/**
	 * 京东C端链接
	 */
    private String jdSkuUrl;
	/**
	 * 单品状态：1：已上架 2：已下架 0 ：已删除
	 */
    private Integer skuStatus;
	/**
	 * 三级类目id
	 */
    private Long guideId;
	/**
	 * 三级类目id

	 */
	private List<Long> guideIdList;
	/**
	 * 品牌名称
	 */
    private String brandName;
	/**
	 * 来源电商id
	 */
    private Long supplierId;
	/**
	 * 来源电商id集合
	 */
	private List<Long> supplierIdList;
	/**
	 * 来源电商名称
	 */
    private String supplierName;
	/**
	 * 市场价
	 */
    private BigDecimal marketPrice;
	/**
	 * 协议价
	 */
    private BigDecimal agreementPrice;
	/**
	 * 折扣率
	 */
    private BigDecimal discount;
	/**
	 * 最小起订量
	 */
    private Integer moq;
	/**
	 * 销售单位
	 */
    private String measureName;
	/**
	 * 好评率
	 */
    private BigDecimal goodRate;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;
	/**
	 * 更新人ID
	 */
    private Long updateUserId;
	/**
	 * 更新人名称
	 */
    private String updateUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;

}