package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class DycActActivityRelaCommodityInfo implements Serializable {

    private static final long serialVersionUID = 2890891511790130671L;
    /**
     * 关联ID
     */
    private Long relaId;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 商品池名称，多个商品池用逗号分隔
     */
    private String commodityPoolName;
    /**
     * 单品ID
     */
    private Long skuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 单品名称
     */
    private Integer skuStatus;
    /**
     * 单品名称翻译
     */
    private String skuStatusStr;
    /**
     * 单品图片url
     */
    private String skuUrl;
    /**
     * 一级类目id
     */
    private String firstCatalogId;
    /**
     * 一级类目名称
     */
    private String firstCatalogName;
    /**
     * 二级类目id
     */
    private String secondCatalogId;
    /**
     * 二级类目名称
     */
    private String secondCatalogName;
    /**
     * 三级类目id
     */
    private String threeCatalogId;
    /**
     * 三级类目名称
     */
    private String threeCatalogName;
    /**
     * C端链接
     */
    private String cterminalUrl;
    /**
     * 品牌
     */
    private String brand;
    /**
     * 价格
     */
    private BigDecimal price;
    /**
     * 好评率
     */
    private Double favorableRate;

    /**
     * 好评率百分比
     */
    private String favorableRateStr;
    /**
     * 单品详情
     */
    private String skuDetails;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 商品类目翻译
     */
    private String CatalogNameStr;
    /**
     * 最小价格
     */
    private BigDecimal minPrice;
    /**
     * 最大价格
     */
    private BigDecimal maxPrice;
    /**
     * 好评率排序：ASC：升序，DESC：降序。默认为降序
     */
    private String favorableRateOrder = "DESC";
    /**
     * 排序
     */
    private String orderBy;
}
