package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName DycActDealAlertQryOrderDO
 * @Author 14051
 * @Date 2024/4/16 16:19
 * @Version 1.0
 **/
@Data
public class DycActDealAlertQryOrderDO implements Serializable {
    private static final long serialVersionUID = 3562038029045974550L;

    /**
     * 预警天数
     */
    private Integer dayNum;
    /**
     * 预警类型：1超期未发货，2超期未收货
     */
    private String alertFlag;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 订单ID集合
     */
    private List<String> orderIds;
    /**
     * 状态
     */
    private Integer orderState;
    /**
     * 服务单ID
     */
    private String afsServiceId;
    /**
     * 服务单ID集合
     */
    private List<String> afsServiceIds;
    /**
     * 结算单ID
     */
    private Long fscOrderId;
    /**
     * 结算单ID集合
     */
    private List<Long> fscOrderIds;

    /**
     * 是否只发送一次 1是
     */
    private Integer isOnly;

    /**
     * 预警项目编码
     */
    private String alterConfigCOde;

    /**
     * 预警类型
     */
    private Integer alertType;

    /**
     * 发货校验时间
     */
    private Date shipCheckTime;

    /**
     * 收货校验时间
     */
    private Date receiptCheckTime;
}
