package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName DycActFscOrderInfo
 * @Author 14051
 * @Date 2024/4/3 9:44
 * @Version 1.0
 * @Description TODO
 **/
@Data
public class DycActFscOrderInfo implements Serializable {
    private static final long serialVersionUID = 4567187917915629070L;
    /**
     * 结算单ID
     */
    private Long fscOrderId;
    /**
     * 结算单来源
     */
    private Integer orderSource;
    /**
     * 开票方类型：1、电商
     */
    private Integer makeType;
    /**
     * 收票方类型：1、采购商 2、运营方
     */
    private Integer receiveType;
    /**
     * 结算单编号
     */
    private String orderNo;
    /**
     * 总金额
     */
    private BigDecimal totalCharge;
    /**
     * 结算单状态
     */
    private Integer orderState;
    /**
     * 供应商ID
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人用户ID
     */
    private Long createUserId;
    /**
     * 创建人用户名称
     */
    private String createOperName;
    /**
     * 创建人机构ID
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 创建人机构树路径
     */
    private String createOrgPath;
    /**
     * 取消时间
     */
    private Date cancelTime;
    /**
     * 付款时间
     */
    private Date payTime;
    /**
     * 最后付款日期
     */
    private Date lastPayTime;
    /**
     * 最后付款日期(运营)
     */
    private Date yyLastPayTime;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 签收时间
     */
    private Date signTime;
    /**
     * 签收人
     */
    private String signOperName;
    /**
     * 开票时间
     */
    private Date billTime;
    /**
     * 快递公司
     */
    private String logisticsCompany;
    /**
     * 快递单号
     */
    private String logisticsOrder;
    /**
     * 预警类型
     */
    private Integer alertType;
    /**
     * 活动组织范围名称
     */
    private String activityScopeOrgName;
}
