package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 DycActUserScoresBaseInfo
 * 说明 用户积分信息
 * 时间 2024/4/16 14:42
 *
 * @author 唐富强
 */
@Data
public class DycActUserScoresBaseInfo implements Serializable {

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动场景id
     */
    private Long activitySceneId;

    /**
     * 活动场景名称
     */
    private String activitySceneName;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动类型
     */
    private Integer activityType;


    /**
     * 活动开始时间
     */
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    private Date activityEndTime;

    /**
     * 活动状态
     */
    private String activityState;


    /**
     * 发放积分
     */
    private BigDecimal giveScores;

    /**
     * 已使用积分
     */
    private BigDecimal usedScores;

    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * 活动浮窗图url
     */
    private String emergePicUrl;
    /**
     * 活动app端banner图url
     */
    private String appBannerPicUrl;

    /**
     * 用户id
     */
    private Long userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 是否已经发送预警通知：1：发送 0或空:未发送
     */
    private Integer isNotify;

    /**
     * 外部活动id
     */
    private String extActivityId;

    /**
     * 执行自动任务类型 1、自动生效 2、自动失效
     */
    private Integer autoType;

}
