package com.tydic.dyc.act.model.bo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题 DycActUserScoresBaseInfoQueryBO
 * 说明 用户信息查询BO
 * 时间 2024/4/16 14:54
 *
 * @author 唐富强
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DycActUserScoresBaseInfoQueryBO extends BasePageReqBo {

    private static final long serialVersionUID = -4114175423594198290L;
    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动场景id
     */
    private Long activitySceneId;

    /**
     * 活动类型:1:工会活动；2：公司活动
     */
    private Integer activityType;

    /**
     * 活动状态
     */
    private String activityState;

    /**
     * 用户id
     */
    private Long userId;


    /**
     * 活动状态集合
     */
    private List<String> activityStateList;

    /**
     * 活动结束时间
     */
    private Date activityEndTimeStart;
    /**
     * 活动结束时间
     */
    private Date activityEndTimeEnd;

    /**
     * 剩余积分最小值
     */
    private BigDecimal balanceScoresMin;
    /**
     * 剩余积分最大值
     */
    private BigDecimal balanceScoresMax;
    /**
     * 是否已经发送预警通知：1：发送 0或空:未发送
     */
    private Integer isNotify;

    /**
     * 活动同步状态集合  1:待同步           2：同步中  3：同步成功   4：同步失败
     */
    private List<Integer> activitySyncStateList;


    /**
     * 排序规则
     */
    private String orderBy;

    /**
     * 是否执行自动生失效 默认执行
     */
    private Integer isAuto;

    /**
     * 活动id集合
     */
    private List<Long> activityIds;
}
