package com.tydic.dyc.act.model.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：DycActiveBaseInfoSaveReqBO
 * 说明：
 * 时间： 2023-12-13 14:33
 * 作者 @author LY
 */
@Data
public class DycActiveBaseInfoSaveReqBO implements Serializable {

    private static final long serialVersionUID = 5469847544084053510L;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动场景id
     */
    private Long activitySceneId;
    /**
     * 活动场景名称
     */
    private String activitySceneCode;
    /**
     * 活动场景名称
     */
    private String activitySceneName;
    /**
     * 活动PC端banner图url
     */
    private String pcBannerPicUrl;
    /**
     * 活动浮窗图url
     */
    private String emergePicUrl;
    /**
     * 活动app端banner图url
     */
    private String appBannerPicUrl;
    /**
     * 发票ID
     */
    private Long invoiceId;
    /**
     * 发票抬头
     */
    private String invoiceTitle;
    /**
     * 发票类别;1:纸质发票 2:电子发票
     */
    private Integer invoiceClass;
    /**
     * 发票类型:1:专用发票；2：普通发票
     */
    private Integer invoiceType;
    /**
     * 发票纳税人识别号
     */
    private String invoiceTaxpayerId;
    /**
     * 发票开户银行
     */
    private String invoiceBank;
    /**
     * 发票开户银行账户
     */
    private String invoiceBankAccount;
    /**
     * 发票地址
     */
    private String invoiceAddress;
    /**
     * 发票电话
     */
    private String invoicePhone;
    /**
     * 发票地址Id
     */
    private Long invoiceAddrId;
    /**
     * 发票地址省编码
     */
    private String provinceId;
    /**
     * 发票地址省名称
     */
    private String provinceName;
    /**
     * 发票地址地市名称
     */
    private String cityName;
    /**
     * 发票地址地市编号
     */
    private String cityId;
    /**
     * 发票地址乡镇编号
     */
    private String townName;
    /**
     * 发票地址乡镇名称
     */
    private String townId;
    /**
     * 发票地址区县名称
     */
    private String countyName;
    /**
     * 发票地址区县编号
     */
    private String countyId;
    /**
     * 发票地址联系人
     */
    private String contactName;
    /**
     * 发票地址联系人电话
     */
    private String contactPhone;
    /**
     * 发票地址联系人邮箱
     */
    private String contactEmial;
    /**
     * 发票接收地址
     */
    private String addressDesc;
    /**
     * 活动类型:1:工会活动；2：劳防活动
     */
    private Integer activityType;
    /**
     * 活动期限:1:有限期，2:无限期
     */
    private Integer activityCycleType;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 支付方式:1:积分支付；2：混合支付
     */
    private Integer activityPayMode;
    /**
     * 活动备注
     */
    private String remark;
    /**
     * 商品最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 商品最低价格
     */
    private BigDecimal minPrice;
    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Integer commodityRelaMethod;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 活动附件列表
     */
    private List<DycActivityFileInfo> fileInfoBOS;
    /**
     * 活动供应商集合
     */
    private List<DycActivitySupplierInfo> activitySupplierList;
    /**
     * 活动版本号
     */
    private Integer activityVersion;
    /**
     * 活动同步状态:
     1:待同步
     2：同步中
     3：同步成功
     4：同步失败
     */
    private Integer activitySyncState;
    /**
     * 用户总数
     */
    private Integer totalUser;
    /**
     * 积分总数
     */
    private BigDecimal totalScores;
    /**
     * 商品总数
     */
    private Integer totalCommodity;
    /**
     * 类目总数
     */
    private Integer totalCatalog;
    /**
     * 是否结算:
     0:未结算；
     1：已结算
     */
    private Integer isSettleFlag;
    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    private String activityState;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建开始时间
     */
    private Date createStartTime;
    /**
     * 创建结束时间
     */
    private Date createEndTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新开始时间
     */
    private Date updateTimeStart;
    /**
     * 更新结束时间
     */
    private Date updateTimeEnd;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 创建人机构ID
     */
    private Long orgId;
    /**
     * 创建人机构名称
     */
    private String orgName;
    /**
     * 创建人机构路径
     */
    private String orgTreePathIn;
    /**
     * 创建人公司ID
     */
    private Long companyId;
    /**
     * 创建人公司名称
     */
    private String companyName;
    /**
     * 页签id：
     * 1001：待生效
     * 1002：生效中
     * 1003：已失效
     * 1004：全部
     */
    private String tabId;
    /**
     * 最后付款日期
     */
    private Date lastPayTime;
    /**
     * 最后付款日期
     */
    private Date lastPayTimeStart;
    /**
     * 最后付款日期
     */
    private Date lastPayTimeEnd;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTime;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTimeStart;
    /**
     * 最后付款日期运营
     */
    private Date yyLastPayTimeEnd;
    /**
     * 外部的活动id
     */
    private String extActivityId;
    /**
     * 提前付款天数
     */
    private String jnPayDay;

}
