package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：DycActActivityCommodityPoolInfoBO
 * 说明：活动已选商品池列表分页查询BO
 * 时间： 2023-12-13 15:30
 * 作者 @author LY
 */
@Data
public class DycActivityCommodityPoolInfo implements Serializable {

    private static final long serialVersionUID = -5559856263688492530L;
    /**
     * 关联ID
     */
    private Long relaId;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 商品池ID
     */
    private Long commodityPoolId;
    /**
     * 商品池名称
     */
    private String commodityPoolName;
    /**
     * 适用活动类型
     */
    private String applyActivityType;
    /**
     * 关联商品类型数量
     */
    private Long relaCatalogAmount;
    /**
     * 关联商品数量（来源商品中心）
     */
    private Long relaCommodityAmount;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
}
